/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.environment.model;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.model.ecj.ClasspathEntry;
import org.eclipse.scout.sdk.core.model.ecj.JavaEnvironmentWithEcj;
import org.eclipse.scout.sdk.core.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.model.spi.ClasspathSpi;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.environment.model.ClasspathEntryWithJdt;
import org.eclipse.scout.sdk.s2e.environment.model.ClasspathWithJdt;

public class JavaEnvironmentWithJdt
extends JavaEnvironmentWithEcj {
    private final IJavaProject m_project;
    private FinalValue<Map<IPackageFragmentRoot, ClasspathSpi>> m_classpath;

    public JavaEnvironmentWithJdt(IJavaProject project) {
        this(project, false);
    }

    public JavaEnvironmentWithJdt(IJavaProject project, boolean excludeTestCode) {
        this(project, JavaEnvironmentWithJdt.javaHomeOf(project), excludeTestCode);
    }

    public JavaEnvironmentWithJdt(IJavaProject project, Path javaHome) {
        this(project, javaHome, false);
    }

    public JavaEnvironmentWithJdt(IJavaProject project, Path javaHome, boolean excludeTestCode) {
        this(project, javaHome, JavaEnvironmentWithJdt.toClasspathEntries(project, excludeTestCode));
    }

    protected JavaEnvironmentWithJdt(IJavaProject project, Path javaHome, Collection<ClasspathEntryWithJdt> cp) {
        super(javaHome, cp, null);
        this.m_project = project;
        this.m_classpath = new FinalValue();
    }

    protected ClasspathSpi classpathEntryToSpi(ClasspathEntry entry) {
        return new ClasspathWithJdt((ClasspathEntryWithJdt)entry, (AbstractJavaEnvironment)this);
    }

    protected static Path javaHomeOf(IJavaProject javaProject) {
        try {
            File javaInstallLocation;
            IVMInstall vmInstall = JavaRuntime.getVMInstall((IJavaProject)javaProject);
            if (vmInstall != null && (javaInstallLocation = vmInstall.getInstallLocation()) != null) {
                Path javaInstallPath = javaInstallLocation.toPath();
                if (Files.isDirectory(javaInstallPath.resolve("jre/lib"), new LinkOption[0])) {
                    return javaInstallPath.resolve("jre");
                }
                return javaInstallPath;
            }
            SdkLog.info((CharSequence)"Unable to find Java home location for project '{}'. Using running Java home as fallback.", (Object[])new Object[]{javaProject.getElementName()});
            return null;
        }
        catch (CoreException e) {
            throw new SdkException((Throwable)e);
        }
    }

    protected static List<ClasspathEntryWithJdt> toClasspathEntries(IJavaProject javaProject, boolean excludeTestCode) {
        try {
            IPackageFragmentRoot[] allPackageFragmentRoots = javaProject.getAllPackageFragmentRoots();
            ArrayList<ClasspathEntryWithJdt> result = new ArrayList<ClasspathEntryWithJdt>(allPackageFragmentRoots.length * 2);
            for (IPackageFragmentRoot cpRoot : allPackageFragmentRoots) {
                if (excludeTestCode && cpRoot.getRawClasspathEntry().isTest()) continue;
                String encoding = JavaEnvironmentWithJdt.getEncoding((IJavaElement)cpRoot);
                if (cpRoot.getKind() == 1) {
                    result.add(new ClasspathEntryWithJdt(cpRoot, cpRoot.getResource().getLocation().toFile().toPath(), 1, encoding));
                    continue;
                }
                if (JavaEnvironmentWithJdt.isJreContainerElement(cpRoot)) continue;
                Path cpLocation = cpRoot.getPath().toFile().toPath();
                IPath cpSourceLocation = cpRoot.getSourceAttachmentPath();
                if (cpSourceLocation != null) {
                    result.add(new ClasspathEntryWithJdt(cpRoot, cpSourceLocation.toFile().toPath(), 1, encoding));
                    result.add(new ClasspathEntryWithJdt(cpRoot, cpLocation, 2, null));
                    continue;
                }
                result.add(new ClasspathEntryWithJdt(cpRoot, cpLocation, 3, encoding));
            }
            return result;
        }
        catch (CoreException e) {
            throw new SdkException((Throwable)e);
        }
    }

    protected static boolean isJreContainerElement(IPackageFragmentRoot root) throws JavaModelException {
        IClasspathEntry entry = root.getRawClasspathEntry();
        if (entry.getEntryKind() != 5) {
            return false;
        }
        String type = entry.getPath().segment(0);
        return JavaRuntime.JRE_CONTAINER.equals(type);
    }

    protected static String getEncoding(IJavaElement root) throws CoreException {
        String systemEncoding;
        IContainer c;
        IFile f;
        String charset;
        IResource resource = root.getResource();
        if (resource != null && resource.exists() && (resource instanceof IFile ? JavaEnvironmentWithJdt.isValidEncoding(charset = (f = (IFile)resource).getCharset(true), root) : resource instanceof IContainer && JavaEnvironmentWithJdt.isValidEncoding(charset = (c = (IContainer)resource).getDefaultCharset(true), root))) {
            return charset;
        }
        IPreferencesService preferencesService = Platform.getPreferencesService();
        if (preferencesService != null) {
            IScopeContext[] scopeContext = new IScopeContext[]{new ProjectScope(root.getJavaProject().getProject())};
            String encoding = preferencesService.getString("org.eclipse.core.resources", "encoding", null, scopeContext);
            if (JavaEnvironmentWithJdt.isValidEncoding(encoding, root)) {
                return encoding;
            }
            scopeContext = new IScopeContext[]{InstanceScope.INSTANCE};
            encoding = preferencesService.getString("org.eclipse.core.resources", "encoding", null, scopeContext);
            if (JavaEnvironmentWithJdt.isValidEncoding(encoding, root)) {
                return encoding;
            }
        }
        if ((systemEncoding = System.getProperty("file.encoding")) != null) {
            return systemEncoding;
        }
        return StandardCharsets.UTF_8.name();
    }

    protected static boolean isValidEncoding(String encoding, IJavaElement root) {
        if (Strings.isBlank((CharSequence)encoding)) {
            return false;
        }
        if (!Charset.isSupported(encoding)) {
            SdkLog.warning((CharSequence)"Charset '{}' of classpath entry '{}' is not supported by this platform. Trying to decode using default charset.", (Object[])new Object[]{encoding, root.getElementName()});
            return false;
        }
        return true;
    }

    protected Map<IPackageFragmentRoot, ClasspathSpi> getClasspathMap() {
        return (Map)this.m_classpath.computeIfAbsentAndGet(() -> {
            List classpath = this.getClasspath();
            HashMap<IPackageFragmentRoot, ClasspathSpi> result = new HashMap<IPackageFragmentRoot, ClasspathSpi>(classpath.size());
            for (ClasspathSpi cp : classpath) {
                ClasspathWithJdt jdtCp = (ClasspathWithJdt)cp;
                result.put(jdtCp.getRoot(), cp);
            }
            return result;
        });
    }

    protected void cleanup() {
        this.m_classpath = new FinalValue();
        super.cleanup();
    }

    public IJavaProject javaProject() {
        return this.m_project;
    }

    public ClasspathSpi getClasspathFor(IPackageFragmentRoot root) {
        return this.getClasspathMap().get(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock();
        synchronized (object) {
            this.m_classpath.opt().ifPresent(Map::clear);
            super.close();
        }
    }
}

