/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.apidef.ScoutModelHierarchy;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;

public class TypeProposalContext {
    private final FinalValue<TypeDeclaration> m_declaringType = new FinalValue();
    private final FinalValue<ITypeBinding> m_declaringTypeBinding = new FinalValue();
    private ScoutModelHierarchy m_scoutModelHierarchy;
    private String m_proposalIfcTypeFqn;
    private int m_pos;
    private List<String> m_defaultSuperClasses;
    private String m_defaultName;
    private String m_suffix;
    private String m_searchString;
    private Future<EclipseEnvironment> m_provider;
    private Future<CompilationUnit> m_compilationUnit;
    private ICompilationUnit m_icu;
    private ISourceRange m_surroundingTypeNameRange;

    public TypeDeclaration getDeclaringType() {
        return (TypeDeclaration)this.m_declaringType.computeIfAbsentAndGet(() -> {
            CompilationUnit cu = (CompilationUnit)Ensure.notNull((Object)this.getCompilationUnit(), (CharSequence)"No AST found for '{}'.", (Object[])new Object[]{this.m_icu.getElementName()});
            ASTNode surroundingTypeName = NodeFinder.perform((ASTNode)cu, (ISourceRange)this.getSurroundingTypeNameRange());
            return (TypeDeclaration)Ensure.notNull((Object)((TypeDeclaration)ASTNodes.getParent((ASTNode)surroundingTypeName, TypeDeclaration.class)));
        });
    }

    public int getInsertPosition() {
        return this.m_pos;
    }

    void setPosition(int pos) {
        this.m_pos = pos;
    }

    public List<String> getDefaultSuperClasses() {
        return this.m_defaultSuperClasses;
    }

    void setDefaultSuperClasses(Collection<String> defaultSuperClasses) {
        this.m_defaultSuperClasses = new ArrayList<String>(defaultSuperClasses);
    }

    public IJavaEnvironment getJavaEnvironment() {
        return this.getProvider().toScoutJavaEnvironment(this.m_icu.getJavaProject());
    }

    public String getDefaultName() {
        return this.m_defaultName;
    }

    void setDefaultName(String defaultName) {
        this.m_defaultName = defaultName;
    }

    public String getSuffix() {
        return this.m_suffix;
    }

    void setSuffix(String suffix) {
        this.m_suffix = suffix;
    }

    public ITypeBinding getDeclaringTypeBinding() {
        return (ITypeBinding)this.m_declaringTypeBinding.computeIfAbsentAndGet(() -> (ITypeBinding)Ensure.notNull((Object)this.getDeclaringType().resolveBinding(), (CharSequence)"No type binding available for '{}'.", (Object[])new Object[]{this.getDeclaringType()}));
    }

    public EclipseEnvironment getProvider() {
        try {
            return this.m_provider.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SdkException((Throwable)e);
        }
    }

    void setProvider(Future<EclipseEnvironment> provider) {
        this.m_provider = provider;
    }

    public String getProposalInterfaceFqn() {
        return this.m_proposalIfcTypeFqn;
    }

    void setProposalInterfaceFqn(String proposalIfcTypeFqn) {
        this.m_proposalIfcTypeFqn = proposalIfcTypeFqn;
    }

    public ICompilationUnit getIcu() {
        return this.m_icu;
    }

    void setIcu(ICompilationUnit icu) {
        this.m_icu = icu;
    }

    public String getSearchString() {
        return this.m_searchString;
    }

    void setSearchString(String searchString) {
        this.m_searchString = searchString;
    }

    public CompilationUnit getCompilationUnit() {
        try {
            return (CompilationUnit)((Future)Ensure.notNull(this.m_compilationUnit)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SdkException((Throwable)e);
        }
    }

    void setCompilationUnit(Future<CompilationUnit> compilationUnit) {
        this.m_compilationUnit = compilationUnit;
    }

    public ISourceRange getSurroundingTypeNameRange() {
        return this.m_surroundingTypeNameRange;
    }

    void setSurroundingTypeNameRange(ISourceRange surroundingTypeNameRange) {
        this.m_surroundingTypeNameRange = surroundingTypeNameRange;
    }

    public ScoutModelHierarchy getScoutModelHierarchy() {
        return this.m_scoutModelHierarchy;
    }

    public void setScoutModelHierarchy(ScoutModelHierarchy scoutModelHierarchy) {
        this.m_scoutModelHierarchy = scoutModelHierarchy;
    }
}

