/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.jaxws;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.s2e.operation.jaxws.WebServiceNewOperation;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.ui.internal.jaxws.WebServiceMessageDialog;
import org.eclipse.scout.sdk.s2e.ui.internal.jaxws.WebServiceNewWizardPage;
import org.eclipse.scout.sdk.s2e.ui.internal.jaxws.editor.WebServiceEditorInput;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizard;
import org.eclipse.scout.sdk.s2e.ui.wizard.WizardFinishTask;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class WebServiceNewWizard
extends AbstractWizard
implements INewWizard {
    private WebServiceNewWizardPage m_page1;
    private WizardFinishTask<WebServiceNewOperation> m_finishTask;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.m_page1 = new WebServiceNewWizardPage();
        this.addPage((IWizardPage)this.getWebServiceNewWizardPage());
        this.m_finishTask = new WizardFinishTask(workbench.getDisplay());
        this.m_finishTask.withOperation(WebServiceNewOperation::new).withMapper(this::mapPageToOperation).withUiAction(WebServiceNewWizard::afterOperation);
        this.setWindowTitle(this.getWebServiceNewWizardPage().getTitle());
        this.setHelpAvailable(true);
        this.setDefaultPageImageDescriptor(S2ESdkUiActivator.getImageDescriptor("newscoutprj_wiz.png"));
    }

    protected void mapPageToOperation(WizardFinishTask.PageToOperationMappingInput input, WebServiceNewOperation op) {
        WebServiceNewWizardPage.WebServiceType webServiceType = this.getWebServiceNewWizardPage().getWebServiceType();
        boolean createConsumer = WebServiceNewWizardPage.WebServiceType.CONSUMER_FROM_EXISTING_WSDL == webServiceType;
        boolean createFromEmptyWsdl = WebServiceNewWizardPage.WebServiceType.PROVIDER_FROM_EMPTY_WSDL == webServiceType;
        op.setCreateConsumer(createConsumer);
        op.setCreateEmptyWsdl(createFromEmptyWsdl);
        if (createFromEmptyWsdl) {
            op.setWsdlName(this.getWebServiceNewWizardPage().getWsdlName());
        } else {
            try {
                if (createConsumer) {
                    op.setWsdlUrl(new URL(this.getWebServiceNewWizardPage().getConsumerWsdlUrl()));
                } else {
                    op.setWsdlUrl(new URL(this.getWebServiceNewWizardPage().getProviderWsdlUrl()));
                }
            }
            catch (MalformedURLException e) {
                SdkLog.error((CharSequence)"Invalid URL.", (Object[])new Object[]{e});
            }
        }
        op.setCreateNewModule(this.getWebServiceNewWizardPage().isCreateNewProject());
        if (this.getWebServiceNewWizardPage().isCreateNewProject()) {
            op.setServerModule(this.getWebServiceNewWizardPage().getServerProject());
            op.setArtifactId(this.getWebServiceNewWizardPage().getArtifactId());
        } else {
            op.setJaxWsProject(this.getWebServiceNewWizardPage().getExistingJaxWsProject());
        }
        op.setPackage(this.getWebServiceNewWizardPage().getTargetPackage());
    }

    protected static void afterOperation(WebServiceNewOperation op, Display d) {
        WebServiceNewWizard.showJaxwsEditor(op, d);
        WebServiceMessageDialog.open(op, d);
    }

    protected static void showJaxwsEditor(WebServiceNewOperation operation, Display d) {
        IJavaProject jaxWsProject = operation.getJaxWsProject();
        if (!JdtUtils.exists((IJavaElement)jaxWsProject)) {
            return;
        }
        IFile jaxwsFile = WebServiceNewWizard.findJaxwsFileIn((IResource)jaxWsProject.getProject());
        if (jaxwsFile == null) {
            return;
        }
        String wsdlName = operation.getCreatedWsdlFile().getFileName().toString();
        d.asyncExec(() -> WebServiceNewWizard.openJaxwsEditor(jaxwsFile, wsdlName));
    }

    protected static IFile findJaxwsFileIn(IResource owner) {
        try {
            IFile[] result = new IFile[1];
            owner.accept(proxy -> {
                IFile resource;
                if (result[0] == null && proxy.getType() == 1 && proxy.getName().toLowerCase(Locale.US).endsWith(".jaxws") && (resource = (IFile)proxy.requestResource()).exists()) {
                    result[0] = resource;
                    return false;
                }
                return true;
            }, 1, 0);
            return result[0];
        }
        catch (CoreException e) {
            SdkLog.info((CharSequence)"Unable to search for thet jaxws file in project.", (Object[])new Object[]{e});
            return null;
        }
    }

    protected static void openJaxwsEditor(IFile jaxwsFile, String wsdlName) {
        S2eUiUtils.openInEditor((IEditorInput)new WebServiceEditorInput(jaxwsFile, wsdlName), "org.eclipse.scout.sdk.s2e.ui.jaxwsEditor", true);
    }

    public WizardFinishTask<WebServiceNewOperation> getFinishTask() {
        return this.m_finishTask;
    }

    public WebServiceNewWizardPage getWebServiceNewWizardPage() {
        return this.m_page1;
    }
}

