/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.ui.project;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.reddeer.eclipse.ui.project.Templatizer;

public class ProjectCreator {
    private final String pluginId;
    private final String pluginProvider;
    private final String pluginVersion;
    private final String pluginName;
    private final boolean generateTest;
    private final IWorkspaceRoot root;

    public ProjectCreator(String pluginId, String pluginName, String pluginVersion, String pluginProvider, boolean generateTest, IWorkspaceRoot root) {
        this.pluginId = pluginId;
        this.pluginName = pluginName;
        this.pluginVersion = pluginVersion;
        this.pluginProvider = pluginProvider;
        this.root = root;
        this.generateTest = generateTest;
    }

    public void create() throws CoreException {
        IProject project = this.getProject();
        project.create(null);
        project.open(null);
        project.getFile("build.properties").create(this.stream("_build.properties"), true, null);
        project.getFile(".classpath").create(this.stream("_classpath"), true, null);
        IFolder folder = project.getFolder("META-INF");
        folder.create(true, true, null);
        folder.getFile("MANIFEST.MF").create(this.stream("_MANIFEST.MF"), true, null);
        project.getFile(".project").setContents(this.stream("_project"), true, false, null);
        IFolder src = project.getFolder("src");
        src.create(true, true, null);
        if (this.generateTest) {
            IFolder org = src.getFolder("org");
            org.create(true, true, null);
            IFolder reddeer = org.getFolder("reddeer");
            reddeer.create(true, true, null);
            IFolder test = reddeer.getFolder("test");
            test.create(true, true, null);
            test.getFile("RedDeerTest.java").create(this.stream("_REDDEER_TEST_JAVA"), true, null);
            project.getFile("pluginCustomization.ini").create(this.stream("pluginCustomization.ini"), true, null);
            project.getFile("RedDeerTest.launch").create(this.stream("RedDeerTest.launch"), true, null);
        }
    }

    public void delete() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.pluginId);
        try {
            project.delete(true, null);
        }
        catch (CoreException e) {
            throw new RuntimeException("Could not delete project " + project.getName(), e);
        }
    }

    private InputStream stream(String path) {
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("org/eclipse/reddeer/eclipse/ui/project/" + path);
        String contents = new Templatizer(this.pluginId, this.pluginName, this.pluginVersion, this.pluginProvider).templatize(this.read(resourceAsStream));
        return new ByteArrayInputStream(contents.getBytes());
    }

    private String read(InputStream is) {
        StringBuffer buffer = new StringBuffer();
        InputStreamReader in = null;
        try {
            try {
                in = new InputStreamReader(is, "utf-8");
                while (in.ready()) {
                    buffer.append((char)in.read());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            this.close(in);
            throw throwable;
        }
        this.close(in);
        return buffer.toString();
    }

    private void close(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private IProject getProject() {
        return this.root().getProject(this.pluginId);
    }

    private IWorkspaceRoot root() {
        return this.root;
    }

    public void generateTest() {
    }
}

