/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.ui.launcher;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.properties.RedDeerProperties;
import org.eclipse.reddeer.common.properties.RedDeerPropertyType;
import org.eclipse.reddeer.eclipse.ui.launcher.DialogTextEditor;
import org.eclipse.reddeer.eclipse.ui.launcher.RedDeerLauncherProperties;
import org.eclipse.reddeer.ui.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class RedDeerJUnitTab
extends AbstractLaunchConfigurationTab {
    private TableViewer propertiesViewer;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setLayout(composite);
        composite.setFont(parent.getFont());
        this.setControl((Control)composite);
        Group propertiesGroup = new Group(composite, 0);
        this.setLayout((Composite)propertiesGroup);
        propertiesGroup.setText("Configuration properties");
        this.propertiesViewer = this.createPropertiesSection((Composite)propertiesGroup);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
    }

    public String getName() {
        return "RedDeer";
    }

    public Image getImage() {
        return Activator.getDefault().getImageRegistry().get("reddeer_runner");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        RedDeerLauncherProperties[] currentInput;
        RedDeerLauncherProperties[] redDeerLauncherPropertiesArray = currentInput = RedDeerLauncherProperties.getInitialRedDeerLauncherProperties();
        int n = currentInput.length;
        int n2 = 0;
        while (n2 < n) {
            RedDeerLauncherProperties property = redDeerLauncherPropertiesArray[n2];
            try {
                property.load(configuration);
            }
            catch (CoreException coreException) {
                throw new RedDeerException("Cannot read launcher configuration");
            }
            ++n2;
        }
        this.propertiesViewer.setInput((Object)currentInput);
        this.propertiesViewer.refresh();
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        RedDeerJUnitTab.savePropertiesToLaunchConfiguration(config, (RedDeerLauncherProperties[])this.propertiesViewer.getInput());
    }

    static void savePropertiesToLaunchConfiguration(ILaunchConfigurationWorkingCopy config, RedDeerLauncherProperties[] properties) {
        RedDeerLauncherProperties[] redDeerLauncherPropertiesArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            RedDeerLauncherProperties property = redDeerLauncherPropertiesArray[n2];
            property.save(config);
            ++n2;
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean isDoubleDefined = false;
        try {
            List<RedDeerLauncherProperties> properties = RedDeerLauncherProperties.loadAll(launchConfig);
            for (RedDeerLauncherProperties property : properties) {
                boolean bl = isDoubleDefined = isDoubleDefined || property.isDoubleDefined();
            }
        }
        catch (CoreException coreException) {
            throw new RedDeerException("Cannot read launcher configuration");
        }
        if (isDoubleDefined) {
            this.setErrorMessage("Some RedDeer parameters are defined on Arguments tab, VM arguments section. You need to remove them.");
        } else {
            this.setErrorMessage(null);
        }
        return super.isValid(launchConfig) && !isDoubleDefined;
    }

    private void setLayout(Composite composite) {
        GridLayout layout = new GridLayout(1, true);
        GridData layoutData = new GridData(4, 4, true, true);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)layoutData);
    }

    private void setLayout(Table table) {
        GridData gd = new GridData(1808);
        gd.heightHint = 90;
        table.setLayoutData((Object)gd);
        ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnWeightData(150, 150), new ColumnWeightData(120, 120)};
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < layouts.length) {
            layout.addColumnData(layouts[i]);
            ++i;
        }
        table.setLayout((Layout)layout);
    }

    private TableViewer createPropertiesSection(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 68356);
        Table table = viewer.getTable();
        this.setLayout(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(parent.getFont());
        TableViewerColumn nameColumn = new TableViewerColumn(viewer, 0);
        nameColumn.setLabelProvider((CellLabelProvider)new NameLabelProvider());
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setResizable(true);
        nameColumn.getColumn().setMoveable(true);
        TableViewerColumn valueColumn = new TableViewerColumn(viewer, 0);
        valueColumn.setLabelProvider((CellLabelProvider)new ValueLabelProvider());
        valueColumn.getColumn().setText("Value");
        valueColumn.getColumn().setResizable(true);
        valueColumn.getColumn().setMoveable(true);
        valueColumn.setEditingSupport((EditingSupport)new RedDeerEditingSupport((ColumnViewer)viewer));
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        return viewer;
    }

    private class NameLabelProvider
    extends ColumnLabelProvider {
        private NameLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof RedDeerLauncherProperties) {
                RedDeerLauncherProperties property = (RedDeerLauncherProperties)element;
                return property.getProperty().getName();
            }
            return null;
        }
    }

    private class RedDeerEditingSupport
    extends EditingSupport {
        public RedDeerEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            if (element instanceof RedDeerLauncherProperties) {
                RedDeerLauncherProperties property = (RedDeerLauncherProperties)element;
                RedDeerProperties prop = ((RedDeerLauncherProperties)element).getProperty();
                if (prop.equals((Object)RedDeerProperties.CONFIG_FILE) || prop.equals((Object)RedDeerProperties.RELATIVE_SCREENSHOT_DIRECTORY)) {
                    DialogTextEditor dte = new DialogTextEditor((Composite)this.getViewer().getControl());
                    dte.addListener(new CustomCellEditorListener((CellEditor)dte, element));
                    return dte;
                }
                if (property.getProperty().getType() == RedDeerPropertyType.TEXT) {
                    TextCellEditor te = new TextCellEditor((Composite)this.getViewer().getControl());
                    te.addListener((ICellEditorListener)new CustomCellEditorListener((CellEditor)te, element));
                    return te;
                }
                if (property.getProperty().getType() == RedDeerPropertyType.FLOAT) {
                    TextCellEditor te = new TextCellEditor((Composite)this.getViewer().getControl());
                    te.addListener((ICellEditorListener)new CustomCellEditorListener((CellEditor)te, element));
                    return te;
                }
                ComboBoxViewerCellEditor cellEditor = new ComboBoxViewerCellEditor((Composite)this.getViewer().getControl(), 8);
                cellEditor.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider());
                cellEditor.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                cellEditor.setInput((Object)property.getProperty().getSupportedValues());
                cellEditor.addListener((ICellEditorListener)new CustomCellEditorListener((CellEditor)cellEditor, element));
                return cellEditor;
            }
            return null;
        }

        protected Object getValue(Object element) {
            if (element instanceof RedDeerLauncherProperties) {
                RedDeerLauncherProperties property = (RedDeerLauncherProperties)element;
                if (property.getCurrentValue() == null) {
                    return "";
                }
                return property.getCurrentValue();
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof RedDeerLauncherProperties) {
                RedDeerLauncherProperties property = (RedDeerLauncherProperties)element;
                if (value == null || value.equals("")) {
                    property.setCurrentValue(null);
                } else {
                    property.setCurrentValue(value.toString());
                }
            }
            this.getViewer().update(element, null);
            RedDeerJUnitTab.this.setDirty(true);
            RedDeerJUnitTab.this.updateLaunchConfigurationDialog();
        }

        private class CustomCellEditorListener
        implements ICellEditorListener {
            private CellEditor editor;
            private Object element;

            public CustomCellEditorListener(CellEditor editor, Object element) {
                this.editor = editor;
                this.element = element;
            }

            public void applyEditorValue() {
            }

            public void cancelEditor() {
            }

            public void editorValueChanged(boolean arg0, boolean arg1) {
                RedDeerEditingSupport.this.setValue(this.element, this.editor.getValue());
            }
        }
    }

    private class ValueLabelProvider
    extends ColumnLabelProvider {
        private ValueLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof RedDeerLauncherProperties) {
                RedDeerLauncherProperties property = (RedDeerLauncherProperties)element;
                return property.getCurrentValue();
            }
            return null;
        }
    }
}

