/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.extension.before.test.impl;

import org.eclipse.core.runtime.Platform;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.properties.RedDeerProperties;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.m2e.core.ui.preferences.MavenPreferencePage;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.extensionpoint.IBeforeTest;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class DoNotDownloadMavenIndexesExt
implements IBeforeTest {
    private static final Logger log = Logger.getLogger(DoNotDownloadMavenIndexesExt.class);
    private static final boolean DISABLE_MAVEN_DOWNLOAD_REPO_INDEX = RedDeerProperties.DISABLE_MAVEN_REPOSITORY_DOWNLOAD.getBooleanValue();

    public void runBeforeTestClass(String config, TestClass testClass) {
        this.disableMavenDownloadRepoIndexOnStartup();
    }

    public void runBeforeTest(String config, Object target, FrameworkMethod method) {
    }

    private void disableMavenDownloadRepoIndexOnStartup() {
        String updateIndexesPreferenceString = Platform.getPreferencesService().getString("org.eclipse.m2e.core", "eclipse.m2.updateIndexes", "true", null);
        if (updateIndexesPreferenceString == null) {
            return;
        }
        if (updateIndexesPreferenceString.equalsIgnoreCase("false")) {
            return;
        }
        log.debug("Trying to disable downloading maven repo indexes on startup via Windows > Preferences > Maven");
        WorkbenchPreferenceDialog preferencesDialog = new WorkbenchPreferenceDialog();
        MavenPreferencePage mavenPreferencePage = new MavenPreferencePage((ReferencedComposite)preferencesDialog);
        preferencesDialog.open();
        try {
            preferencesDialog.select((PreferencePage)mavenPreferencePage);
        }
        catch (RedDeerException redDeerException) {
            preferencesDialog.cancel();
            return;
        }
        mavenPreferencePage.setDownloadRepoIndexOnStartup(false);
        preferencesDialog.ok();
        log.debug("Downloading maven repo indexes on startup disabled");
    }

    public boolean hasToRun() {
        return DISABLE_MAVEN_DOWNLOAD_REPO_INDEX;
    }

    public long getPriority() {
        return 1000L;
    }
}

