/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.remote.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.rcptt.internal.launching.remote.ui.AUTArgumentsBlock;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class RemoteAUTMainTab
extends AbstractLaunchConfigurationTab {
    private AUTArgumentsBlock fLocationBlock;
    private final Job validateJob = new Job("Connection validate job"){
        {
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            String lastMessage = RemoteAUTMainTab.this.getErrorMessage();
            String msg = RemoteAUTMainTab.this.fLocationBlock.validate();
            if (msg == null && lastMessage == null || msg != null && msg.equals(lastMessage)) {
                return Status.OK_STATUS;
            }
            RemoteAUTMainTab.this.setErrorMessage(msg);
            final Control control = RemoteAUTMainTab.super.getControl();
            if (control.isDisposed()) {
                return Status.OK_STATUS;
            }
            control.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!control.isDisposed()) {
                        RemoteAUTMainTab.this.updateLaunchConfigurationDialog();
                    }
                }
            });
            return Status.OK_STATUS;
        }
    };

    public RemoteAUTMainTab() {
        this.createLocationBlock();
    }

    protected long getUpdateJobDelay() {
        return 200L;
    }

    protected void updateLaunchConfigurationDialog() {
        this.validateJob.cancel();
        this.validateJob.schedule();
        super.updateLaunchConfigurationDialog();
    }

    private void createLocationBlock() {
        this.fLocationBlock = new AUTArgumentsBlock(this);
    }

    public void createControl(Composite parent) {
        final ScrolledComposite scrollContainer = new ScrolledComposite(parent, 512);
        scrollContainer.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite((Composite)scrollContainer, 0);
        scrollContainer.setContent((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        this.fLocationBlock.createControl(composite);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                Control child = (Control)e.widget;
                Rectangle bounds = child.getBounds();
                Rectangle area = scrollContainer.getClientArea();
                Point origin = scrollContainer.getOrigin();
                if (origin.x > bounds.x) {
                    origin.x = Math.max(0, bounds.x);
                }
                if (origin.y > bounds.y) {
                    origin.y = Math.max(0, bounds.y);
                }
                if (origin.x + area.width < bounds.x + bounds.width) {
                    origin.x = Math.max(0, bounds.x + bounds.width - area.width);
                }
                if (origin.y + area.height < bounds.y + bounds.height) {
                    origin.y = Math.max(0, bounds.y + bounds.height - area.height);
                }
                scrollContainer.setOrigin(origin);
            }
        };
        Control[] controls = composite.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].addListener(26, listener);
            ++i;
        }
        Dialog.applyDialogFont((Control)composite);
        composite.setSize(composite.computeSize(-1, -1));
        scrollContainer.setExpandHorizontal(true);
        this.setControl((Control)scrollContainer);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.fLocationBlock.initializeFrom(config);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        this.fLocationBlock.performApply(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        this.fLocationBlock.setDefaults(config);
    }

    public String getName() {
        return "Remote AUT Launch configuration";
    }
}

