/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.util.compression.huffmancoder;

import java.nio.ByteBuffer;
import org.eclipse.ptp.proxy.util.compression.IDecoder;
import org.eclipse.ptp.proxy.util.compression.huffmancoder.ByteSymbolTable;
import org.eclipse.ptp.proxy.util.compression.huffmancoder.HuffmanCoder;
import org.eclipse.ptp.proxy.util.compression.huffmancoder.ISymbolDefiner;
import org.eclipse.ptp.proxy.util.messages.Messages;

public class HuffmanByteUncompress
implements IDecoder {
    private static final int NSYMBOLS = 256;
    private HuffmanCoder huffmanCoder;
    private final ISymbolDefiner symbolTable = new ByteSymbolTable();
    private boolean freqUpdated;

    public ByteBuffer apply(ByteBuffer in) {
        int i;
        if (in == null) {
            throw new IllegalArgumentException(Messages.getString("HuffmanByteUncompress.0"));
        }
        int[] frequencies = new int[256];
        in.position(0);
        int uncompressedlen = in.getInt();
        if (this.freqUpdated) {
            i = 0;
            while (i < 256) {
                frequencies[i] = in.getInt();
                ++i;
            }
        } else if (this.huffmanCoder == null) {
            i = 0;
            while (i < 256) {
                frequencies[i] = 1;
                ++i;
            }
            this.freqUpdated = true;
        }
        if (this.freqUpdated) {
            this.huffmanCoder = new HuffmanCoder(this.symbolTable, frequencies);
            this.huffmanCoder.buildHuffmanTree();
            this.freqUpdated = false;
        }
        ByteBuffer result = this.huffmanCoder.decode(in.slice(), uncompressedlen);
        result.rewind();
        return result;
    }

    public void notifyFrequencyUpdate() {
        this.freqUpdated = true;
    }
}

