/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui.views.variable;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.debug.core.event.IPDebugEvent;
import org.eclipse.ptp.debug.core.event.IPDebugInfo;
import org.eclipse.ptp.internal.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.internal.debug.ui.PVariableManager;
import org.eclipse.ptp.internal.debug.ui.views.AbstractPDebugViewEventHandler;
import org.eclipse.ptp.internal.debug.ui.views.variable.PVariableView;
import org.eclipse.ptp.internal.ui.listeners.IJobChangedListener;
import org.eclipse.ui.IViewPart;

public class PVariableViewEventHandler
extends AbstractPDebugViewEventHandler
implements IJobChangedListener {
    private final PVariableManager varMgr = PTPDebugUIPlugin.getUIDebugManager().getJobVariableManager();

    public PVariableViewEventHandler(PVariableView view) {
        super((IViewPart)view);
        PTPDebugUIPlugin.getUIDebugManager().addJobChangedListener(this);
    }

    public void dispose() {
        PTPDebugUIPlugin.getUIDebugManager().removeJobChangedListener(this);
        super.dispose();
    }

    public PVariableView getPVariableView() {
        return (PVariableView)this.getView();
    }

    public void refresh(boolean all) {
        if (this.getPVariableView().isVisible()) {
            this.getPVariableView().refresh();
        }
    }

    protected void doHandleDebugEvent(IPDebugEvent event, IProgressMonitor monitor) {
        switch (event.getKind()) {
            case 1: {
                IPDebugInfo info = event.getInfo();
                this.varMgr.resetValue(info.getLaunch().getJobId(), info.getAllTasks());
            }
        }
    }

    public void jobChangedEvent(int type, String cur_job_id, String pre_job_id) {
        switch (type) {
            case 0: {
                break;
            }
            case 1: {
                if (pre_job_id == null) break;
                this.varMgr.removeVariable(pre_job_id);
                this.refresh();
            }
        }
        this.getPVariableView().updateActionsEnable();
    }
}

