/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.template.contentassist;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableType;

public class MultiVariable
extends TemplateVariable {
    private static final Object DEFAULT_KEY = new Object();
    private final Map<Object, Object[]> fValueMap = new HashMap<Object, Object[]>();
    private Object fKey = DEFAULT_KEY;
    private Object fCurrentChoice;

    public MultiVariable(TemplateVariableType type, String name, int[] offsets) {
        super(type, name, name, offsets);
        this.fValueMap.put(this.fKey, new String[]{name});
        this.fCurrentChoice = this.getChoices()[0];
    }

    public void setChoices(Object key, Object[] values) {
        Assert.isNotNull((Object)key);
        Assert.isTrue((values.length > 0 ? 1 : 0) != 0);
        if (this.fValueMap != null) {
            this.fValueMap.put(key, values);
            if (key.equals(this.fKey)) {
                this.fCurrentChoice = this.getChoices()[0];
            }
            this.setResolved(true);
        }
    }

    public void setKey(Object defaultKey) {
        Assert.isTrue((boolean)this.fValueMap.containsKey(defaultKey));
        if (!this.fKey.equals(defaultKey)) {
            this.fKey = defaultKey;
            this.fCurrentChoice = this.getChoices()[0];
        }
    }

    public Object getCurrentChoice() {
        return this.fCurrentChoice;
    }

    public void setCurrentChoice(Object currentChoice) {
        Assert.isTrue((boolean)Arrays.asList(this.getChoices()).contains(currentChoice));
        this.fCurrentChoice = currentChoice;
    }

    public void setValues(String[] values) {
        this.setChoices(values);
    }

    public void setChoices(Object[] values) {
        this.setChoices(DEFAULT_KEY, values);
    }

    public String getDefaultValue() {
        return this.toString(this.fCurrentChoice);
    }

    public String toString(Object object) {
        return object.toString();
    }

    public String[] getValues() {
        Object[] values = this.getChoices();
        String[] result = new String[values.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.toString(values[i]);
            ++i;
        }
        return result;
    }

    public Object[] getChoices() {
        return this.getChoices(this.fKey);
    }

    public Object[] getChoices(Object key) {
        return this.fValueMap.get(key);
    }

    public Object[][] getAllChoices() {
        return (Object[][])this.fValueMap.values().toArray((T[])new Object[this.fValueMap.size()][]);
    }
}

