/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class PHPBasePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DOUBLE_CLICK = "scriptExplorerDoubleclick";
    private static final String DOUBLE_CLICK_EXPANDS = "scriptExplorerDoubleclickExpands";
    private static final String DOUBLE_CLICK_GOES_INTO = "scriptExplorerDoubleclickGointo";
    private ArrayList<?> fCheckBoxes;
    private ArrayList<Button> fRadioButtons;
    private ArrayList<?> fTextControls;

    public PHPBasePreferencePage() {
        this.setPreferenceStore(DLTKUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(PHPUIMessages.PHPBasePreferencePage_description);
        this.fRadioButtons = new ArrayList();
        this.fCheckBoxes = new ArrayList();
        this.fTextControls = new ArrayList();
    }

    public void init(IWorkbench workbench) {
    }

    private Button addRadioButton(Composite parent, String label, String key, String value) {
        GridData gd = new GridData(256);
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setData((Object)new String[]{key, value});
        button.setLayoutData((Object)gd);
        button.setSelection(value.equals(DLTKUIPlugin.getDefault().getPreferenceStore().getString(key)));
        this.fRadioButtons.add(button);
        return button;
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        result.setLayout((Layout)layout);
        Group doubleClickGroup = new Group(result, 0);
        doubleClickGroup.setLayout((Layout)new GridLayout());
        doubleClickGroup.setLayoutData((Object)new GridData(768));
        doubleClickGroup.setText(PHPUIMessages.PHPBasePreferencePage_doubleclick_action);
        this.addRadioButton((Composite)doubleClickGroup, PHPUIMessages.PHPBasePreferencePage_doubleclick_gointo, DOUBLE_CLICK, DOUBLE_CLICK_GOES_INTO);
        this.addRadioButton((Composite)doubleClickGroup, PHPUIMessages.PHPBasePreferencePage_doubleclick_expand, DOUBLE_CLICK, DOUBLE_CLICK_EXPANDS);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    protected void performDefaults() {
        String key;
        Button button;
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fCheckBoxes.size()) {
            button = (Button)this.fCheckBoxes.get(i);
            key = (String)button.getData();
            button.setSelection(store.getDefaultBoolean(key));
            ++i;
        }
        i = 0;
        while (i < this.fRadioButtons.size()) {
            button = this.fRadioButtons.get(i);
            String[] info = (String[])button.getData();
            button.setSelection(info[1].equals(store.getDefaultString(info[0])));
            ++i;
        }
        i = 0;
        while (i < this.fTextControls.size()) {
            Text text = (Text)this.fTextControls.get(i);
            key = (String)text.getData();
            text.setText(store.getDefaultString(key));
            ++i;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        String key;
        Button button;
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fCheckBoxes.size()) {
            button = (Button)this.fCheckBoxes.get(i);
            key = (String)button.getData();
            store.setValue(key, button.getSelection());
            ++i;
        }
        i = 0;
        while (i < this.fRadioButtons.size()) {
            button = this.fRadioButtons.get(i);
            if (button.getSelection()) {
                String[] info = (String[])button.getData();
                store.setValue(info[0], info[1]);
            }
            ++i;
        }
        i = 0;
        while (i < this.fTextControls.size()) {
            Text text = (Text)this.fTextControls.get(i);
            key = (String)text.getData();
            store.setValue(key, text.getText());
            ++i;
        }
        try {
            InstanceScope.INSTANCE.getNode("org.eclipse.php.ui").flush();
        }
        catch (BackingStoreException e) {
            Logger.logException(e);
        }
        return super.performOk();
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.php.help.preferences");
        super.performHelp();
    }
}

