/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.profile.ui.launcher.AbstractProfileWebLaunchSettingsSection;
import org.eclipse.php.profile.ui.launcher.Messages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ZendDebuggerProfileWebLaunchSettingsSection
extends AbstractProfileWebLaunchSettingsSection {
    private Group browserGroup;
    private Button openBrowserButton;

    @Override
    public void initialize(ILaunchConfiguration configuration) {
        super.initialize(configuration);
        try {
            boolean isOpenInBrowser = configuration.getAttribute("org.eclipse.php.debug.core.OpenInBrowser", PHPDebugPlugin.getOpenInBrowserOption());
            this.openBrowserButton.setSelection(isOpenInBrowser);
        }
        catch (CoreException coreException) {}
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        boolean isOpenInBrowser = this.openBrowserButton.getSelection();
        configuration.setAttribute("org.eclipse.php.debug.core.OpenInBrowser", isOpenInBrowser);
    }

    @Override
    protected void buildSection(Composite parent) {
        super.buildSection(parent);
        this.createBrowserGroup(parent);
    }

    protected void createBrowserGroup(Composite parent) {
        this.browserGroup = new Group(parent, 0);
        this.browserGroup.setLayout((Layout)new GridLayout(1, false));
        this.browserGroup.setLayoutData((Object)new GridData(768));
        this.browserGroup.setText(Messages.ZendDebuggerProfileWebLaunchSettingsSection_Browser);
        this.openBrowserButton = new Button((Composite)this.browserGroup, 32);
        this.openBrowserButton.setText(Messages.ZendDebuggerProfileWebLaunchSettingsSection_Open_in_browser);
        this.openBrowserButton.setLayoutData((Object)new GridData(768));
        this.openBrowserButton.addSelectionListener((SelectionListener)this.widgetListener);
    }
}

