/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.resources;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.oomph.internal.resources.ExternalResource;
import org.eclipse.oomph.internal.resources.ResourcesPlugin;
import org.eclipse.oomph.predicates.PredicatesUtil;
import org.eclipse.oomph.resources.Messages;
import org.eclipse.oomph.resources.backend.BackendResource;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.Predicate;
import org.eclipse.oomph.util.SubMonitor;
import org.eclipse.oomph.util.XMLUtil;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourcesUtil {
    private ResourcesUtil() {
    }

    private static IWorkspace getWorkspace() {
        return org.eclipse.core.resources.ResourcesPlugin.getWorkspace();
    }

    public static String getProjectName(File folder) throws ParserConfigurationException, Exception {
        DocumentBuilder documentBuilder = XMLUtil.createDocumentBuilder();
        Element rootElement = XMLUtil.loadRootElement((DocumentBuilder)documentBuilder, (File)new File(folder, ".project"));
        final AtomicReference projectName = new AtomicReference();
        XMLUtil.handleChildElements((Element)rootElement, (XMLUtil.ElementHandler)new XMLUtil.ElementHandler(){

            public void handleElement(Element element) throws Exception {
                if ("name".equals(element.getTagName())) {
                    projectName.set(element.getTextContent().trim());
                }
            }
        });
        return (String)projectName.get();
    }

    public static BackendResource getBackendResource(IResource resource) {
        try {
            Object sessionProperty = resource.getSessionProperty(ExternalResource.BACKEND_RESOURCE_PROPERTY_NAME);
            if (sessionProperty instanceof BackendResource) {
                return (BackendResource)sessionProperty;
            }
        }
        catch (CoreException ex) {
            ResourcesPlugin.INSTANCE.log(ex);
        }
        return null;
    }

    public static boolean isLocal(IResource resource) {
        BackendResource backendResource = ResourcesUtil.getBackendResource(resource);
        if (backendResource != null) {
            return backendResource.isLocal();
        }
        URI locationURI = resource.getLocationURI();
        if (locationURI != null) {
            String scheme = locationURI.getScheme();
            return "file".equalsIgnoreCase(scheme);
        }
        return false;
    }

    public static void runWithFiles(IProject project, IPath path, Predicate<IFile> filter, RunnableWithFile runnable) throws Exception {
        IFolder iFolder = project.getFolder(path);
        if (iFolder.exists()) {
            IResource[] iResourceArray = iFolder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray[n2];
                if (iResource.exists() && iResource instanceof IFile && filter.apply((Object)((IFile)iResource))) {
                    ResourcesUtil.runWithFile(project, iResource.getProjectRelativePath(), runnable);
                }
                ++n2;
            }
        }
    }

    public static void runWithFile(IProject project, IPath path, RunnableWithFile runnable) throws Exception {
        IFile iFile = project.getFile(path);
        if (iFile.exists()) {
            boolean local = ResourcesUtil.isLocal((IResource)iFile);
            File projectFolder = null;
            try {
                File file;
                if (!local) {
                    projectFolder = File.createTempFile("local-", "");
                    projectFolder.delete();
                    file = new File(projectFolder, path.toOSString());
                    IOUtil.mkdirs((File)file.getParentFile());
                    ResourcesUtil.copyFile(iFile, file);
                } else {
                    projectFolder = new File(project.getLocation().toOSString());
                    file = new File(iFile.getLocation().toOSString());
                }
                runnable.run(projectFolder, file);
            }
            finally {
                if (!local) {
                    IOUtil.deleteBestEffort((File)projectFolder);
                }
            }
        }
    }

    public static void copyFile(IFile source, File target) throws CoreException, FileNotFoundException {
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            inputStream = source.getContents();
            outputStream = new FileOutputStream(target);
            IOUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(outputStream);
            IOUtil.closeSilent((Closeable)inputStream);
            throw throwable;
        }
        IOUtil.closeSilent((Closeable)outputStream);
        IOUtil.closeSilent((Closeable)inputStream);
    }

    public static int importProjects(final Collection<File> projectLocations, IProgressMonitor monitor) throws CoreException {
        if (projectLocations.isEmpty()) {
            return 0;
        }
        final AtomicInteger count = new AtomicInteger();
        ResourcesUtil.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)projectLocations.size()).detectCancelation();
                try {
                    try {
                        for (File folder : projectLocations) {
                            if (ResourcesUtil.importProject(folder, (IProgressMonitor)progress.newChild()) != ImportResult.IMPORTED) continue;
                            count.incrementAndGet();
                        }
                    }
                    catch (Exception ex) {
                        ResourcesPlugin.INSTANCE.coreException(ex);
                        progress.done();
                    }
                }
                finally {
                    progress.done();
                }
            }
        }, monitor);
        return count.get();
    }

    public static ImportResult importProject(File projectLocation, IProgressMonitor monitor) throws Exception {
        String projectName = ResourcesUtil.getProjectName(projectLocation);
        if (projectName == null || projectName.length() == 0) {
            ResourcesPlugin.INSTANCE.log(NLS.bind((String)Messages.ResourcesUtil_NoProjectName_message, (Object)projectLocation));
            return ImportResult.ERROR;
        }
        return ResourcesUtil.importProject(projectLocation, projectName, monitor);
    }

    public static ImportResult importProject(File projectLocation, String projectName, IProgressMonitor monitor) throws IOException, CoreException {
        IPath defaultDefaultLocation;
        File location = projectLocation.getCanonicalFile();
        IWorkspace workspace = ResourcesUtil.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(projectName);
        if (project.exists()) {
            return ResourcesUtil.importExistingProject(project, projectName, location);
        }
        Path locationPath = new Path(location.getAbsolutePath());
        IPath parentPath = locationPath.removeLastSegments(1);
        if (ResourcesUtil.isPrefixOf(parentPath, defaultDefaultLocation = root.getLocation()) && ResourcesUtil.isPrefixOf(defaultDefaultLocation, parentPath)) {
            String lastSegment = locationPath.lastSegment();
            if (!projectName.equals(lastSegment)) {
                project = root.getProject(lastSegment);
                projectName = lastSegment;
                if (project.exists()) {
                    return ResourcesUtil.importExistingProject(project, projectName, location);
                }
            }
            locationPath = null;
        }
        monitor.setTaskName(NLS.bind((String)Messages.ResourcesUtil_ImportingProject_task, (Object)projectName));
        IProjectDescription projectDescription = workspace.newProjectDescription(projectName);
        projectDescription.setLocation((IPath)locationPath);
        project.create(projectDescription, monitor);
        if (!project.isOpen()) {
            project.open(monitor);
        }
        return ImportResult.IMPORTED;
    }

    private static ImportResult importExistingProject(IProject project, String projectName, File location) throws IOException {
        File existingLocation = new File(project.getLocation().toOSString()).getCanonicalFile();
        if (!existingLocation.equals(location)) {
            ResourcesPlugin.INSTANCE.log(NLS.bind((String)Messages.ResourcesUtil_DifferentLocation_message, (Object)projectName, (Object)existingLocation));
            return ImportResult.EXISTED_DIFFERENT_LOCATION;
        }
        return ImportResult.EXISTED;
    }

    private static boolean isPrefixOf(IPath location1, IPath location2) {
        return FileUtil.isPrefixOf((IPath)location1, (IPath)location2);
    }

    public static void clearWorkspace() throws CoreException {
        final IWorkspace workspace = ResourcesUtil.getWorkspace();
        workspace.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IWorkspaceRoot root = workspace.getRoot();
                Object[] objectArray = root.getProjects();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = objectArray[n2];
                    project.delete(true, null);
                    ++n2;
                }
                objectArray = root.getLocation().toFile().listFiles();
                n = objectArray.length;
                n2 = 0;
                while (n2 < n) {
                    IProject file = objectArray[n2];
                    if (file.isDirectory() && !".metadata".equals(file.getName())) {
                        IOUtil.deleteBestEffort((File)file);
                    }
                    ++n2;
                }
            }
        }, null);
    }

    public static IMarker[] buildWorkspace(boolean clean, String markerType) throws CoreException {
        IWorkspace workspace = ResourcesUtil.getWorkspace();
        if (clean) {
            workspace.build(15, null);
            workspace.build(6, null);
        } else {
            workspace.build(10, null);
        }
        if (markerType == null) {
            return null;
        }
        return workspace.getRoot().findMarkers(markerType, false, 2);
    }

    @Deprecated
    public static boolean matchesPredicates(IProject project, EList<org.eclipse.oomph.predicates.Predicate> predicates) {
        return PredicatesUtil.matchesPredicates((IResource)project, predicates);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImportResult {
        EXISTED,
        EXISTED_DIFFERENT_LOCATION,
        IMPORTED,
        ERROR;

    }

    public static interface RunnableWithFile {
        public void run(File var1, File var2) throws Exception;
    }
}

