/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.cs2as;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.xtext.base.cs2as.CS2ASConversion;
import org.eclipse.ocl.xtext.base.cs2as.Continuation;
import org.eclipse.ocl.xtext.base.cs2as.Dependency;
import org.eclipse.ocl.xtext.base.cs2as.PivotDependency;
import org.eclipse.ocl.xtext.base.cs2as.ValidationDiagnostic;
import org.eclipse.ocl.xtext.basecs.ModelElementCS;
import org.eclipse.ocl.xtext.basecs.PivotableElementCS;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public abstract class BasicContinuation<T>
implements Continuation<T> {
    private static final @NonNull Dependency @NonNull [] EMPTY_DEPENDENCIES = new Dependency[0];
    static final Logger logger = Logger.getLogger(BasicContinuation.class);
    protected final @NonNull CS2ASConversion context;
    protected final Element pivotParent;
    protected final EStructuralFeature pivotFeature;
    protected final @NonNull T csElement;
    protected final @NonNull Dependency @NonNull [] dependencies;

    protected static @NonNull Dependency @NonNull [] createDependencies(@Nullable PivotableElementCS csElement) {
        Dependency[] dependencyArray;
        if (csElement != null) {
            PivotDependency[] pivotDependencyArray = new PivotDependency[1];
            dependencyArray = pivotDependencyArray;
            pivotDependencyArray[0] = new PivotDependency(csElement);
        } else {
            dependencyArray = EMPTY_DEPENDENCIES;
        }
        return dependencyArray;
    }

    public BasicContinuation(@NonNull CS2ASConversion context, Element pivotParent, EStructuralFeature pivotFeature, @NonNull T csElement, Dependency ... dependencies) {
        this.context = context;
        this.pivotParent = pivotParent;
        this.pivotFeature = pivotFeature;
        this.csElement = csElement;
        Dependency[] dependencyArray = this.dependencies = dependencies != null ? dependencies : EMPTY_DEPENDENCIES;
        assert (csElement != null);
    }

    public void addError(@NonNull String message) {
        if (this.csElement instanceof ModelElementCS) {
            ModelElementCS csModelElement = (ModelElementCS)this.csElement;
            ICompositeNode node = NodeModelUtils.getNode((EObject)csModelElement);
            ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, message);
            csModelElement.eResource().getErrors().add((Object)resourceDiagnostic);
        } else {
            logger.error((Object)message);
        }
    }

    @Override
    public void addTo(@NonNull List<BasicContinuation<?>> simpleContinuations) {
        simpleContinuations.add(this);
    }

    public boolean canExecute() {
        Dependency[] dependencyArray = this.dependencies;
        int n = this.dependencies.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull Dependency dependency = dependencyArray[n2];
            if (!dependency.canExecute()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public abstract BasicContinuation<?> execute();

    public @NonNull Dependency @NonNull [] getDependencies() {
        return this.dependencies;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getClass().getSimpleName());
        s.append("@");
        s.append(Integer.toHexString(this.hashCode()));
        s.append(" : ");
        if (this.pivotParent != null) {
            s.append(this.pivotParent.eClass().getName());
        } else if (this.csElement instanceof EObject) {
            s.append(((EObject)this.csElement).eClass().getName());
        } else {
            s.append("???");
        }
        s.append(".");
        s.append(this.pivotFeature != null ? this.pivotFeature.getName() : "*");
        s.append(" : ");
        s.append(this.csElement.toString());
        return s.toString();
    }
}

