/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.sdk.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.commons.sdk.util.FixtureConfiguration;
import org.eclipse.osgi.util.NLS;

public class TestConfiguration {
    private static final String URL_SERVICES_LOCALHOST = System.getProperty("localhost.test.server", "http://localhost:2080");
    private static final String URL_SERVICES_DEFAULT = System.getProperty("mylyn.test.server", "http://mylyn.org");
    public static TestConfiguration defaultConfiguration;
    private boolean localOnly;
    private boolean defaultOnly;
    private boolean headless;

    public static TestConfiguration getDefault() {
        if (defaultConfiguration == null) {
            defaultConfiguration = new TestConfiguration();
            defaultConfiguration.setDefaultOnly(CommonTestUtil.runHeartbeatTestsOnly());
        }
        return defaultConfiguration;
    }

    public static void setDefault(TestConfiguration defaultConfiguration) {
        TestConfiguration.defaultConfiguration = defaultConfiguration;
    }

    public boolean isDefaultOnly() {
        return this.defaultOnly;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public boolean isLocalOnly() {
        return this.localOnly;
    }

    public void setDefaultOnly(boolean heartbeat) {
        this.defaultOnly = heartbeat;
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    public void setLocalOnly(boolean localOnly) {
        this.localOnly = localOnly;
    }

    public <T> List<T> discover(Class<T> clazz, String fixtureType) {
        return this.discover(clazz, fixtureType, this.isDefaultOnly());
    }

    public <T> T discoverDefault(Class<T> clazz, String fixtureType) {
        List<T> fixtures = this.discover(clazz, fixtureType, true);
        if (fixtures.isEmpty()) {
            throw new RuntimeException(NLS.bind((String)"No default fixture available for {0}", (Object)fixtureType));
        }
        return fixtures.get(0);
    }

    public <T> List<T> discover(Class<T> clazz, String fixtureType, boolean defaultOnly) {
        List fixtures = Collections.emptyList();
        Exception[] exception = new Exception[1];
        if (!CommonTestUtil.ignoreLocalTestServices()) {
            try {
                File file = CommonTestUtil.getFile(clazz, "local.json");
                fixtures = TestConfiguration.discover(file.toURI().toASCIIString(), "", clazz, fixtureType, defaultOnly, exception);
            }
            catch (AssertionFailedError assertionFailedError) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (fixtures.isEmpty()) {
                fixtures = TestConfiguration.discover(String.valueOf(URL_SERVICES_LOCALHOST) + "/cgi-bin/services", URL_SERVICES_LOCALHOST, clazz, fixtureType, defaultOnly, exception);
            }
        }
        if (fixtures.isEmpty()) {
            fixtures = TestConfiguration.discover(String.valueOf(URL_SERVICES_DEFAULT) + "/cgi-bin/services", URL_SERVICES_DEFAULT, clazz, fixtureType, defaultOnly, exception);
        }
        if (fixtures.isEmpty()) {
            throw new RuntimeException(NLS.bind((String)"Failed to discover any fixtures for kind {0} with defaultOnly={1} ({2} and {3})", (Object[])new Object[]{fixtureType, Boolean.toString(defaultOnly), URL_SERVICES_LOCALHOST, URL_SERVICES_DEFAULT}), exception[0]);
        }
        return fixtures;
    }

    private static <T> List<T> discover(String location, String baseUrl, Class<T> clazz, String fixtureType, boolean defaultOnly, Exception[] result) {
        Assert.isNotNull((Object)fixtureType);
        List<FixtureConfiguration> configurations = TestConfiguration.getConfigurations(location, result);
        if (configurations != null) {
            for (FixtureConfiguration configuration : configurations) {
                if (configuration == null) continue;
                configuration.setUrl(String.valueOf(baseUrl) + configuration.getUrl());
            }
            return TestConfiguration.loadFixtures(configurations, clazz, fixtureType, defaultOnly);
        }
        return Collections.emptyList();
    }

    private static <T> List<T> loadFixtures(List<FixtureConfiguration> configurations, Class<T> clazz, String fixtureType, boolean defaultOnly) {
        ArrayList<T> result = new ArrayList<T>();
        String defaultOverwriteUrl = System.getProperty("mylyn.tests.configuration.url", "");
        for (FixtureConfiguration configuration : configurations) {
            if (configuration == null || !fixtureType.equals(configuration.getType()) || defaultOnly && (!defaultOverwriteUrl.equals("") || !configuration.isDefault()) && !configuration.url.equals(defaultOverwriteUrl)) continue;
            try {
                Constructor<T> constructor = clazz.getConstructor(FixtureConfiguration.class);
                result.add(constructor.newInstance(configuration));
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error creating test fixture", e);
            }
        }
        return result;
    }

    private static List<FixtureConfiguration> getConfigurations(String url, Exception[] result) {
        List list;
        URLConnection connection = new URL(url).openConnection();
        InputStreamReader in = new InputStreamReader(connection.getInputStream());
        try {
            TypeToken<List<FixtureConfiguration>> type = new TypeToken<List<FixtureConfiguration>>(){};
            list = (List)new Gson().fromJson((Reader)in, type.getType());
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                result[0] = new IOException("IOException accessing " + url, e);
                return null;
            }
        }
        in.close();
        return list;
    }
}

