/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.efacet.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.modisco.facet.efacet.core.FacetUtils;
import org.eclipse.modisco.facet.efacet.core.IFacetManagerListener;
import org.eclipse.modisco.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.modisco.facet.efacet.core.internal.Activator;
import org.eclipse.modisco.facet.efacet.core.internal.FacetManager;
import org.eclipse.modisco.facet.efacet.core.internal.exception.UnmatchingExpectedTypeException;
import org.eclipse.modisco.facet.efacet.core.internal.exported.IResolverManager;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.modisco.facet.util.core.DebugUtils;
import org.eclipse.modisco.facet.util.core.Logger;
import org.eclipse.modisco.facet.util.core.internal.exported.ListUtils;
import org.eclipse.modisco.facet.util.emf.core.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FacetManagerContext
implements List<FacetSet> {
    private static final String SILENT_OPTION = "org.eclipse.modisco.facet.efacet.core.internal.FacetManagerContext.getOverrideCandidateFeatures.silent";
    private static final boolean SILENT = Boolean.getBoolean("org.eclipse.modisco.facet.efacet.core.internal.FacetManagerContext.getOverrideCandidateFeatures.silent");
    private static final boolean DEBUG = DebugUtils.getDebugStatus((Plugin)Activator.getDefault());
    private LinkedList<FacetSet> managedFacetSets = new LinkedList();
    private final transient FacetManager manager;
    private final Set<ETypedElement> failingFeatures = new HashSet<ETypedElement>();
    private final Set<IFacetManagerListener> listeners = new HashSet<IFacetManagerListener>();

    public FacetManagerContext(FacetManager manager) {
        this.manager = manager;
    }

    public <T extends ETypedElement> T resolveOverrides(T baseFeature, EObject eObject) throws FacetManagerException {
        Object result = baseFeature;
        if (baseFeature instanceof DerivedTypedElement) {
            DerivedTypedElement derivedResult = this.resolveOverrides((DerivedTypedElement)baseFeature, eObject);
            if (derivedResult != null && !(derivedResult instanceof ETypedElement)) {
                throw new UnmatchingExpectedTypeException("Type mismatch in override resolution '" + baseFeature.getName() + "'");
            }
            result = derivedResult;
        }
        if (result == null) {
            result = baseFeature;
        }
        return result;
    }

    public <T extends DerivedTypedElement> T resolveOverrides(T baseFeature, EObject eObject) throws FacetManagerException {
        try {
            T signatureFeature = FacetUtils.getTopOverrideFeature(baseFeature);
            List<T> orderedCandidates = this.getOverrideCandidateFeatures(eObject, signatureFeature);
            return FacetManagerContext.findMostSpecificFeature(orderedCandidates);
        }
        catch (Exception e) {
            throw new FacetManagerException(e);
        }
    }

    public <T extends DerivedTypedElement> T getSuperOf(T currentFeature, EObject eObject) throws FacetManagerException {
        try {
            T signatureFeature = FacetUtils.getTopOverrideFeature(currentFeature);
            List<T> orderedCandidates = this.getOverrideCandidateFeatures(eObject, signatureFeature);
            int mostSpecificIndex = orderedCandidates.indexOf(currentFeature);
            if (mostSpecificIndex == -1) {
                throw new IllegalStateException("\"currentFeature\" must exists in \"orderedCandidates\"");
            }
            int lastIndex = orderedCandidates.size() - 1;
            T result = null;
            if (mostSpecificIndex != lastIndex) {
                int superIndex = mostSpecificIndex + 1;
                result = orderedCandidates.get(superIndex);
            }
            return result;
        }
        catch (Exception e) {
            throw new FacetManagerException(e);
        }
    }

    public List<FacetSet> getManagedFacetSets() {
        return Collections.unmodifiableList(new ArrayList<FacetSet>(this.managedFacetSets));
    }

    public void setManagedFacetSets(List<FacetSet> facetSets) {
        this.managedFacetSets = new LinkedList<FacetSet>(facetSets);
        this.notifyListeners();
    }

    public void addBackManagedFacetSet(FacetSet facetSet) {
        this.managedFacetSets.remove(facetSet);
        this.managedFacetSets.addLast(facetSet);
        this.notifyListeners();
    }

    public void addFrontManagedFacetSet(FacetSet facetSet) {
        if (this.managedFacetSets == null) {
            this.managedFacetSets = new LinkedList();
        }
        this.managedFacetSets.remove(facetSet);
        this.managedFacetSets.addFirst(facetSet);
        this.notifyListeners();
    }

    private static <T extends DerivedTypedElement> T findMostSpecificFeature(List<T> orderedCandidates) {
        DerivedTypedElement result = null;
        if (!orderedCandidates.isEmpty()) {
            Iterator<T> candidatesIt = orderedCandidates.iterator();
            result = (DerivedTypedElement)candidatesIt.next();
            while (candidatesIt.hasNext()) {
                DerivedTypedElement candidate = (DerivedTypedElement)candidatesIt.next();
                if (!FacetManagerContext.isOverridenBy(candidate, result)) continue;
                result = candidate;
            }
        }
        return (T)result;
    }

    private <T extends DerivedTypedElement> List<T> getOverrideCandidateFeatures(EObject eObject, T baseFeature) throws FacetManagerException {
        ResourceSet baserFeatureRS = baseFeature.eResource().getResourceSet();
        LinkedList<T> result = new LinkedList<T>();
        List<FacetSet> managedFSets = this.getManagedFacetSets();
        ArrayList<FacetSet> allFacetSets = new ArrayList<FacetSet>(managedFSets);
        for (FacetSet facetSet : managedFSets) {
            for (FacetSet subFacetSet : facetSet.getFacetSets()) {
                FacetSet resolvedFacetSet = IResolverManager.DEFAULT.resolve(subFacetSet, FacetSet.class);
                allFacetSets.add(resolvedFacetSet);
            }
        }
        for (FacetSet facetSet : allFacetSets) {
            Resource resource = facetSet.eResource();
            if (resource == null) {
                String message = String.format("The facetSet %s (%s) is not stored in a resource.", facetSet.getName(), facetSet.getNsURI());
                Logger.logWarning((String)message, (Plugin)Activator.getDefault());
            } else {
                ResourceSet facetSetRS = resource.getResourceSet();
                if (!facetSetRS.equals(baserFeatureRS)) {
                    Logger.logWarning((String)"The facet manager is dealing with more than one resource set.", (Plugin)Activator.getDefault());
                }
            }
            for (Facet facet : FacetUtils.getFacets(facetSet)) {
                T matchingFeature = this.getMatchingFeature(eObject, facet, baseFeature);
                if (matchingFeature == null) continue;
                result.add(matchingFeature);
            }
        }
        if (result.isEmpty()) {
            if (!this.failingFeatures.contains(baseFeature) && !SILENT) {
                Logger.logWarning((String)("The result of " + this.getClass().getSimpleName() + ".getOverrideCandidateFeatures(...) is empty! baseFeature=" + EcoreUtil.getURI(baseFeature) + " (This message will be sent only once)"), (Plugin)Activator.getDefault());
                this.failingFeatures.add((ETypedElement)baseFeature);
            }
            result.add(baseFeature);
        }
        if (DEBUG) {
            StringBuffer message = new StringBuffer(10);
            message.append('\n');
            for (DerivedTypedElement feature : result) {
                message.append(" - ");
                message.append(FacetUtils.toString(feature));
                message.append('\n');
            }
            DebugUtils.debug((String)message.toString());
        }
        return result;
    }

    private static boolean isOverridenBy(DerivedTypedElement child, DerivedTypedElement targetParent) {
        boolean result = false;
        if (child.equals(targetParent)) {
            result = true;
        } else {
            DerivedTypedElement currentParent = child.getOverride();
            while (!result && currentParent != null) {
                if (currentParent.equals(targetParent)) {
                    result = true;
                    continue;
                }
                currentParent = currentParent.getOverride();
            }
        }
        return result;
    }

    private <T extends DerivedTypedElement> T getMatchingFeature(EObject eObject, Facet facet, T signatureFeature) throws FacetManagerException {
        DerivedTypedElement result = null;
        EList eTypedElements = signatureFeature instanceof EOperation ? facet.getFacetOperations() : facet.getFacetElements();
        for (ETypedElement feature : eTypedElements) {
            DerivedTypedElement tmpFeature;
            FacetManager.ConformanceState conformanceState;
            if (!FacetManagerContext.isMatchingFeature2(signatureFeature, feature) || (conformanceState = this.manager.getConformanceState(eObject, facet)) != FacetManager.ConformanceState.Conformant) continue;
            if (!signatureFeature.getClass().isInstance(feature)) {
                throw new FacetManagerException(String.valueOf(ModelUtils.getQualifiedName((ENamedElement)feature)) + " overrides " + ModelUtils.getQualifiedName(signatureFeature) + " but both are not of the same kind.");
            }
            result = tmpFeature = (DerivedTypedElement)feature;
            break;
        }
        return (T)result;
    }

    private static <T extends DerivedTypedElement> boolean isMatchingFeature2(T signatureFeature, ETypedElement feature) throws FacetManagerException {
        boolean result = false;
        if (signatureFeature.getClass().isInstance(feature)) {
            DerivedTypedElement element = (DerivedTypedElement)feature;
            DerivedTypedElement topFeature = FacetUtils.getTopOverrideFeature(element);
            if (topFeature == signatureFeature) {
                result = true;
            } else {
                Resource topResource = topFeature.eResource();
                Resource signatureResource = signatureFeature.eResource();
                if (topResource == null || signatureResource == null || topFeature.eResource().getResourceSet() != signatureFeature.eResource().getResourceSet()) {
                    Logger.logWarning((String)"topOverrideFeature.eResource().getResourceSet() != signatureFeature.eResource().getResourceSet()", (Plugin)Activator.getDefault());
                }
            }
        }
        return result;
    }

    public void removeFacetSet(FacetSet facetSet) {
        boolean removed = this.managedFacetSets.remove(facetSet);
        if (removed) {
            this.notifyListeners();
        }
    }

    @Override
    public void clear() {
        boolean empty = this.managedFacetSets.isEmpty();
        if (!empty) {
            this.managedFacetSets.clear();
            this.notifyListeners();
        }
    }

    @Override
    public int size() {
        return this.managedFacetSets.size();
    }

    @Override
    public boolean isEmpty() {
        return this.managedFacetSets.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.managedFacetSets.contains(object);
    }

    @Override
    public Iterator<FacetSet> iterator() {
        return new ArrayList<FacetSet>(this.managedFacetSets).iterator();
    }

    @Override
    public Object[] toArray() {
        return this.managedFacetSets.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.managedFacetSets.toArray(array);
    }

    @Override
    public boolean add(FacetSet object) {
        boolean result = false;
        this.managedFacetSets.remove(object);
        if (object != null) {
            result = this.managedFacetSets.add(object);
        }
        if (result) {
            this.notifyListeners();
        }
        return result;
    }

    @Override
    public boolean remove(Object object) {
        boolean isRemoved = this.managedFacetSets.remove(object);
        if (isRemoved) {
            this.notifyListeners();
        }
        return isRemoved;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.managedFacetSets.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends FacetSet> collection) {
        boolean result = false;
        for (FacetSet facetSet : collection) {
            this.managedFacetSets.remove(facetSet);
            if (facetSet == null) continue;
            boolean addResult = this.managedFacetSets.add(facetSet);
            boolean bl = result = result || addResult;
        }
        if (result) {
            this.notifyListeners();
        }
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends FacetSet> collection) {
        ArrayList<FacetSet> filtered = new ArrayList<FacetSet>();
        for (FacetSet facetSet : collection) {
            if (filtered.contains(facetSet)) continue;
            filtered.add(facetSet);
        }
        this.managedFacetSets.removeAll(filtered);
        boolean bl = this.managedFacetSets.addAll(index, ListUtils.cleanList(filtered));
        if (bl) {
            this.notifyListeners();
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean isRemoved = this.managedFacetSets.removeAll(collection);
        if (isRemoved) {
            this.notifyListeners();
        }
        return isRemoved;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean isRetained = this.managedFacetSets.retainAll(collection);
        if (isRetained) {
            this.notifyListeners();
        }
        return isRetained;
    }

    @Override
    public FacetSet get(int index) {
        return this.managedFacetSets.get(index);
    }

    @Override
    public FacetSet set(int index, FacetSet element) {
        FacetSet oldElement = this.managedFacetSets.set(index, element);
        if (!oldElement.equals(element)) {
            this.notifyListeners();
        }
        return oldElement;
    }

    @Override
    public void add(int index, FacetSet element) {
        this.managedFacetSets.remove(element);
        if (element != null) {
            this.managedFacetSets.add(index, element);
            this.notifyListeners();
        }
    }

    @Override
    public FacetSet remove(int index) {
        FacetSet oldElement = this.managedFacetSets.remove(index);
        this.notifyListeners();
        return oldElement;
    }

    @Override
    public int indexOf(Object object) {
        return this.managedFacetSets.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.managedFacetSets.lastIndexOf(object);
    }

    @Override
    public ListIterator<FacetSet> listIterator() {
        return this.managedFacetSets.listIterator();
    }

    @Override
    public ListIterator<FacetSet> listIterator(int index) {
        return this.managedFacetSets.listIterator(index);
    }

    @Override
    public List<FacetSet> subList(int fromIndex, int toIndex) {
        return this.managedFacetSets.subList(fromIndex, toIndex);
    }

    public void addListener(IFacetManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IFacetManagerListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        IFacetManagerListener[] listenersCopy;
        IFacetManagerListener[] iFacetManagerListenerArray = listenersCopy = this.listeners.toArray(new IFacetManagerListener[this.listeners.size()]);
        int n = listenersCopy.length;
        int n2 = 0;
        while (n2 < n) {
            IFacetManagerListener listener = iFacetManagerListenerArray[n2];
            listener.facetManagerChanged();
            ++n2;
        }
    }
}

