/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.pde.BNDInstructions;
import org.eclipse.m2e.pde.MavenTargetLocation;
import org.eclipse.m2e.pde.MissingMetadataMode;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetLocationFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MavenTargetLocationFactory
implements ITargetLocationFactory {
    public ITargetLocation getTargetLocation(String type, String serializedXML) throws CoreException {
        try {
            MissingMetadataMode mode;
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = docBuilder.parse(new ByteArrayInputStream(serializedXML.getBytes(StandardCharsets.UTF_8)));
            Element location = document.getDocumentElement();
            try {
                mode = MissingMetadataMode.valueOf(location.getAttribute("missingManifest").toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                mode = MissingMetadataMode.ERROR;
            }
            String dependencyScope = location.getAttribute("includeDependencyScope");
            String artifactId = this.getText("artifactId", location);
            String groupId = this.getText("groupId", location);
            String version = this.getText("version", location);
            String artifactType = this.getText("type", location);
            String classifier = this.getText("classifier", location);
            NodeList instructionsNodeList = location.getElementsByTagName("instructions");
            NodeList excludesNodeList = location.getElementsByTagName("exclude");
            ArrayList<BNDInstructions> instructions = new ArrayList<BNDInstructions>();
            ArrayList<String> excludes = new ArrayList<String>();
            int instructionsLength = instructionsNodeList.getLength();
            int i = 0;
            while (i < instructionsLength) {
                Node item = instructionsNodeList.item(i);
                if (item instanceof Element) {
                    Element instructionElement = (Element)item;
                    instructions.add(new BNDInstructions(instructionElement.getAttribute("reference"), instructionElement.getTextContent()));
                }
                ++i;
            }
            int excludesLength = excludesNodeList.getLength();
            int i2 = 0;
            while (i2 < excludesLength) {
                Node item = excludesNodeList.item(i2);
                if (item instanceof Element) {
                    excludes.add(((Element)item).getTextContent());
                }
                ++i2;
            }
            return new MavenTargetLocation(groupId, artifactId, version, artifactType, classifier, mode, dependencyScope, Boolean.parseBoolean(location.getAttribute("includeSource")), instructions, excludes);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, MavenTargetLocationFactory.class.getPackage().getName(), e.getMessage(), (Throwable)e));
        }
    }

    private String getText(String tagName, Element location) {
        NodeList nodeList = location.getElementsByTagName(tagName);
        int i = 0;
        while (i < nodeList.getLength()) {
            String textContent = nodeList.item(i).getTextContent();
            if (textContent != null) {
                return textContent;
            }
            ++i;
        }
        return "";
    }
}

