/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.listeners;

import java.text.MessageFormat;
import org.eclipse.linuxtools.internal.dataviewers.piechart.PieChart;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.Messages;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.listeners.ToolTipChartMouseMoveListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.ISeries;

public class PieChartMouseMoveListener
extends ToolTipChartMouseMoveListener {
    public PieChartMouseMoveListener(PieChart chart, Composite parent) {
        super((Chart)chart, (Control)parent);
    }

    @Override
    public void mouseMove(MouseEvent e) {
        super.mouseMove(e);
        ISeries[] allSeries = this.chart.getSeriesSet().getSeries();
        int numPies = allSeries.length > 0 ? allSeries[0].getXSeries().length : 0;
        int pieIndex = 0;
        int sliceIndex = -1;
        while (pieIndex < numPies) {
            sliceIndex = ((PieChart)this.chart).getSliceIndexFromPosition(pieIndex, e.x, e.y);
            if (sliceIndex != -1) break;
            ++pieIndex;
        }
        if (sliceIndex != -1) {
            this.setTextTip(MessageFormat.format(Messages.PieChartBuilder_ToolTipCoords, this.chart.getAxisSet().getXAxis(0).getTitle().getText(), allSeries[sliceIndex].getId(), allSeries[sliceIndex].getXSeries()[pieIndex], (double)Math.round(((PieChart)this.chart).getSlicePercent(pieIndex, sliceIndex) * 100.0) / 100.0));
        } else {
            this.tipShell.setVisible(false);
        }
    }
}

