/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpmstubby.model;

import java.util.Properties;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

public class FeatureModel {
    private Document docroot;
    private XPath xpath;
    private Properties featureProperties;

    public FeatureModel(Document docroot, Properties featureProperties) {
        this.docroot = docroot;
        this.featureProperties = featureProperties;
        this.xpath = XPathFactory.newInstance().newXPath();
    }

    private String xpathEval(String path) {
        String result = "";
        try {
            result = this.xpath.evaluate(path, this.docroot);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return result;
    }

    private String resolveFeatureProperties(String key) {
        if (key != null && key.trim().startsWith("%")) {
            return this.featureProperties.getProperty(key.trim().replaceAll("%", ""));
        }
        return key;
    }

    public String getSimplePackageName() {
        String packageName = this.xpathEval("/feature/@id");
        String[] packageItems = packageName.split("\\.");
        String name = packageItems[packageItems.length - 1];
        if (name.equalsIgnoreCase("feature")) {
            name = packageItems[packageItems.length - 2];
        }
        return name;
    }

    public String getPackageName() {
        return "eclipse-" + this.getSimplePackageName();
    }

    public String getFeatureId() {
        return this.xpathEval("/feature/@id");
    }

    public String getVersion() {
        String version = this.xpathEval("/feature/@version");
        version = version.replaceAll(".qualifier", "");
        return version;
    }

    public String getSummary() {
        return this.resolveFeatureProperties(this.xpathEval("/feature/@label"));
    }

    public String getLicense() {
        String urlString = this.resolveFeatureProperties(this.xpathEval("/feature/license/@url"));
        String urlAnotation = this.resolveFeatureProperties(this.xpathEval("/feature/license"));
        String license = "#FIXME";
        if (urlString != null && urlAnotation != null) {
            if (urlString.indexOf("epl") > -1 || urlAnotation.indexOf("epl") > -1) {
                license = "EPL";
            } else if (urlString.indexOf("cpl") > -1 || urlAnotation.indexOf("cpl") > -1) {
                license = "CPL";
            }
        }
        return license;
    }

    public String getURL() {
        return this.xpathEval("/feature/description/@url");
    }

    public String getDescription() {
        return this.resolveFeatureProperties(this.xpathEval("/feature/description"));
    }
}

