/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.editor.ui.internal.dependencies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.libra.framework.editor.core.model.IBundle;
import org.eclipse.libra.framework.editor.ui.internal.dependencies.BundleDependency;
import org.eclipse.libra.framework.editor.ui.internal.dependencies.BundleDependencyContentProvider;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.zest.core.viewers.IConnectionStyleProvider;
import org.eclipse.zest.core.viewers.IEntityStyleProvider;

public class BundleDependencyLabelProvider
implements ILabelProvider,
IEntityStyleProvider,
IConnectionStyleProvider,
ISelectionChangedListener {
    private final Color blackColor = Display.getCurrent().getSystemColor(2);
    private final Color colorBorder = new Color(null, 0, 0, 0);
    private final Color colorRel = new Color(null, 150, 150, 255);
    private final Color colorRelated = new Color(null, 236, 255, 122);
    private final Color colorRelResolved = new Color(null, 255, 100, 100);
    private final Color colorTestBackground = new Color(null, 255, 255, 255);
    private final Color colorTestHighlight = new Color(null, 182, 217, 0);
    private final BundleDependencyContentProvider contentProvider;
    private final Color grayColor = Display.getCurrent().getSystemColor(15);

    public BundleDependencyLabelProvider(BundleDependencyContentProvider contentProvider, FormToolkit formToolkit) {
        this.contentProvider = contentProvider;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.colorTestBackground.dispose();
        this.colorTestHighlight.dispose();
        this.colorRel.dispose();
        this.colorRelResolved.dispose();
        this.colorBorder.dispose();
        this.colorRelated.dispose();
    }

    public boolean fisheyeNode(Object entity) {
        return false;
    }

    public Color getBackgroundColour(Object entity) {
        if (entity instanceof IBundle && this.contentProvider.isSelected((IBundle)entity)) {
            return this.colorRelated;
        }
        return this.colorTestBackground;
    }

    public Color getBorderColor(Object entity) {
        return this.colorBorder;
    }

    public Color getBorderHighlightColor(Object entity) {
        return this.colorBorder;
    }

    public int getBorderWidth(Object entity) {
        return 1;
    }

    public Color getColor(Object rel) {
        if (rel instanceof BundleDependency) {
            if (this.contentProvider.isSelected((BundleDependency)rel)) {
                return this.blackColor;
            }
            return this.grayColor;
        }
        return this.colorRel;
    }

    public int getConnectionStyle(Object rel) {
        return 8;
    }

    public Color getForegroundColour(Object entity) {
        return this.colorBorder;
    }

    public Color getHighlightColor(Object rel) {
        if (rel instanceof BundleDependency) {
            return this.blackColor;
        }
        return this.colorTestHighlight;
    }

    public Image getImage(Object element) {
        if (element instanceof IBundle) {
            return PDEPluginImages.get((String)PDEPluginImages.OBJ_DESC_BUNDLE);
        }
        return null;
    }

    public int getLineWidth(Object rel) {
        return 1;
    }

    public Color getNodeHighlightColor(Object entity) {
        return this.colorTestHighlight;
    }

    public String getText(Object element) {
        if (element instanceof IBundle) {
            return String.valueOf(((IBundle)element).getSymbolicName()) + " (" + ((IBundle)element).getVersion() + ")";
        }
        return null;
    }

    public IFigure getTooltip(Object entity) {
        return null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }
}

