/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;

public class J2EEUtil {
    private static final String EAR_MODULE = "jst.ear";
    private static final String WEB_MODULE = "jst.web";
    private static final IModule[] EMPTY_LIST = new IModule[0];
    private static Map<IModule, List<IModule>> earCache;
    private static Map<IJ2EEModule, List<IModule>> earCache2;
    private static Map<IModule, List<IModule>> webCache;
    protected static String cache;

    public static IModule[] getEnterpriseApplications(IJ2EEModule module, IProgressMonitor monitor) {
        if (J2EEUtil.shouldUseCache()) {
            List<IModule> list = earCache2.get(module);
            if (list == null) {
                return EMPTY_LIST;
            }
            return list.toArray(new IModule[list.size()]);
        }
        ArrayList<IModule> list = new ArrayList<IModule>();
        IModule[] modules = ServerUtil.getModules((String)EAR_MODULE);
        if (modules != null) {
            IModule[] iModuleArray = modules;
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                IModule[] modules2;
                IModule module2 = iModuleArray[n2];
                IEnterpriseApplication ear = (IEnterpriseApplication)module2.loadAdapter(IEnterpriseApplication.class, monitor);
                if (ear != null && (modules2 = ear.getModules()) != null) {
                    IModule[] iModuleArray2 = modules2;
                    int n3 = modules2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IModule m = iModuleArray2[n4];
                        if (module.equals(m.loadAdapter(IJ2EEModule.class, monitor))) {
                            list.add(module2);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return list.toArray(new IModule[list.size()]);
    }

    public static IModule[] getEnterpriseApplications(IModule module, IProgressMonitor monitor) {
        if (J2EEUtil.shouldUseCache()) {
            List<IModule> list = earCache.get(module);
            if (list == null) {
                return EMPTY_LIST;
            }
            return list.toArray(new IModule[list.size()]);
        }
        ArrayList<IModule> list = new ArrayList<IModule>();
        IModule[] modules = ServerUtil.getModules((String)EAR_MODULE);
        if (modules != null) {
            IModule[] iModuleArray = modules;
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                IModule[] modules2;
                IModule module2 = iModuleArray[n2];
                IEnterpriseApplication ear = (IEnterpriseApplication)module2.loadAdapter(IEnterpriseApplication.class, monitor);
                if (ear != null && (modules2 = ear.getModules()) != null) {
                    IModule[] iModuleArray2 = modules2;
                    int n3 = modules2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IModule m = iModuleArray2[n4];
                        if (module.equals(m)) {
                            list.add(module2);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return list.toArray(new IModule[list.size()]);
    }

    public static IModule[] getWebModules(IModule module, IProgressMonitor monitor) {
        if (J2EEUtil.shouldUseCache()) {
            List<IModule> list = webCache.get(module);
            if (list == null) {
                return EMPTY_LIST;
            }
            return list.toArray(new IModule[list.size()]);
        }
        ArrayList<IModule> list = new ArrayList<IModule>();
        IModule[] modules = ServerUtil.getModules((String)WEB_MODULE);
        if (modules != null) {
            IModule[] iModuleArray = modules;
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                IModule[] modules2;
                IModule module2 = iModuleArray[n2];
                IWebModule web = (IWebModule)module2.loadAdapter(IWebModule.class, monitor);
                if (web != null && (modules2 = web.getModules()) != null) {
                    IModule[] iModuleArray2 = modules2;
                    int n3 = modules2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IModule m = iModuleArray2[n4];
                        if (module.equals(m)) {
                            list.add(module2);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return list.toArray(new IModule[list.size()]);
    }

    private static void fillCache(IProgressMonitor monitor) {
        List<IModule> m;
        IModule mm;
        int n;
        int n2;
        IModule[] iModuleArray;
        IModule[] modules2;
        IModule module2;
        int n3;
        int n4;
        IModule[] iModuleArray2;
        earCache = new HashMap<IModule, List<IModule>>();
        earCache2 = new HashMap<IJ2EEModule, List<IModule>>();
        webCache = new HashMap<IModule, List<IModule>>();
        IModule[] modules = ServerUtil.getModules((String)EAR_MODULE);
        if (modules != null) {
            iModuleArray2 = modules;
            n4 = modules.length;
            n3 = 0;
            while (n3 < n4) {
                module2 = iModuleArray2[n3];
                IEnterpriseApplication ear = (IEnterpriseApplication)module2.loadAdapter(IEnterpriseApplication.class, monitor);
                if (ear != null && (modules2 = ear.getModules()) != null) {
                    iModuleArray = modules2;
                    n2 = modules2.length;
                    n = 0;
                    while (n < n2) {
                        mm = iModuleArray[n];
                        m = earCache.get(mm);
                        if (m == null) {
                            m = new ArrayList<IModule>(2);
                            earCache.put(mm, m);
                        }
                        m.add(module2);
                        IJ2EEModule mod = (IJ2EEModule)mm.loadAdapter(IJ2EEModule.class, monitor);
                        if (mod != null) {
                            m = earCache2.get(mod);
                            if (m == null) {
                                m = new ArrayList<IModule>(2);
                                earCache2.put(mod, m);
                            }
                            m.add(module2);
                        }
                        ++n;
                    }
                }
                ++n3;
            }
        }
        if ((modules = ServerUtil.getModules((String)WEB_MODULE)) != null) {
            iModuleArray2 = modules;
            n4 = modules.length;
            n3 = 0;
            while (n3 < n4) {
                module2 = iModuleArray2[n3];
                IWebModule web = (IWebModule)module2.loadAdapter(IWebModule.class, monitor);
                if (web != null && (modules2 = web.getModules()) != null) {
                    iModuleArray = modules2;
                    n2 = modules2.length;
                    n = 0;
                    while (n < n2) {
                        mm = iModuleArray[n];
                        m = webCache.get(mm);
                        if (m == null) {
                            m = new ArrayList<IModule>(2);
                            webCache.put(mm, m);
                        }
                        m.add(module2);
                        ++n;
                    }
                }
                ++n3;
            }
        }
    }

    private static boolean shouldUseCache() {
        String s = System.getProperty("J2EEcache");
        if (s == null || "".equals(s) || "false".equals(s)) {
            webCache = null;
            earCache = null;
            return false;
        }
        if (cache == null || !cache.equals(s)) {
            cache = s;
            J2EEUtil.fillCache(null);
        }
        return true;
    }
}

