/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.property;

import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.property.LengthMeta;
import org.eclipse.jst.pagedesigner.css2.property.TableUtil;
import org.eclipse.jst.pagedesigner.css2.value.Length;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSValue;

public class BorderWidthMeta
extends LengthMeta {
    private static final Length LENGTH_4 = new Length(4, false);
    static final String[] KEYWORDS = new String[]{"auto", "thin", "medium", "thick"};

    public BorderWidthMeta() {
        super(false, LENGTH_4);
    }

    protected String[] getKeywordValues() {
        return KEYWORDS;
    }

    public int getPercentageType() {
        return 0;
    }

    public Object calculateCSSValueResult(CSSValue value, String propertyName, ICSSStyle style) {
        Object stylevalue = style.getStyleProperty("border-" + BorderWidthMeta.extractEdge(propertyName) + "-style");
        if ("none".equals(stylevalue) || "hidden".equals(stylevalue)) {
            return Length.LENGTH_0;
        }
        Object obj = super.calculateCSSValueResult(value, propertyName, style);
        if ("thin".equals(obj)) {
            return Length.LENGTH_1;
        }
        if ("medium".equals(obj)) {
            return Length.LENGTH_3;
        }
        if ("thick".equals(obj)) {
            return Length.LENGTH_8;
        }
        return obj;
    }

    public Object calculateHTMLAttributeOverride(Element element, String htmltag, String propertyName, ICSSStyle style) {
        String border;
        if ("table".equalsIgnoreCase(htmltag)) {
            return this.calculateTableOverride(element, propertyName);
        }
        if ("td".equalsIgnoreCase(htmltag) || "th".equalsIgnoreCase(htmltag)) {
            return this.calculateTDOverride(element, propertyName);
        }
        if ("img".equalsIgnoreCase(htmltag) && (border = DOMUtil.getAttributeIgnoreCase(element, "border")) != null) {
            try {
                return new Length(Integer.parseInt(border), false);
            }
            catch (Exception exception) {}
        }
        return super.calculateHTMLAttributeOverride(element, htmltag, propertyName, style);
    }

    private Object calculateTDOverride(Element element, String propertyName) {
        Node parent = element;
        Element tableEle = null;
        while ((parent = parent.getParentNode()) != null && parent instanceof Element) {
            if (!parent.getTagName().equalsIgnoreCase("table")) continue;
            tableEle = (Element)parent;
            break;
        }
        if (tableEle != null) {
            String rules = DOMUtil.getAttributeIgnoreCase(tableEle, "rules");
            String borderstr = DOMUtil.getAttributeIgnoreCase(tableEle, "border");
            if (rules == null || rules.length() == 0) {
                if (borderstr == null || "0".equals(borderstr.trim())) {
                    return null;
                }
                return Length.LENGTH_1;
            }
            if (TableUtil.matchRules(BorderWidthMeta.extractEdge(propertyName), rules)) {
                return Length.LENGTH_1;
            }
            return Length.LENGTH_0;
        }
        return Length.LENGTH_0;
    }

    private Object calculateTableOverride(Element element, String propertyName) {
        String frame = DOMUtil.getAttributeIgnoreCase(element, "frame");
        String borderstr = DOMUtil.getAttributeIgnoreCase(element, "border");
        if ("0".equals(borderstr)) {
            return Length.LENGTH_0;
        }
        if (frame == null || frame.length() == 0) {
            if (borderstr == null) {
                return null;
            }
            if (borderstr.trim().length() == 0) {
                return Length.LENGTH_1;
            }
            try {
                return new Length(Integer.parseInt(borderstr), false);
            }
            catch (Exception exception) {
                frame = borderstr;
            }
        }
        if (TableUtil.matchFrame(BorderWidthMeta.extractEdge(propertyName), frame)) {
            if (borderstr != null) {
                try {
                    return new Length(Integer.parseInt(borderstr), false);
                }
                catch (Exception exception) {}
            }
            return Length.LENGTH_1;
        }
        return Length.LENGTH_0;
    }

    static String extractEdge(String propertyName) {
        if ("border-bottom-width".equalsIgnoreCase(propertyName)) {
            return "bottom";
        }
        if ("border-left-width".equalsIgnoreCase(propertyName)) {
            return "left";
        }
        if ("border-right-width".equalsIgnoreCase(propertyName)) {
            return "right";
        }
        return "top";
    }

    public static boolean isBorderWidth(String propertyName) {
        return "border-bottom-width".equalsIgnoreCase(propertyName) || "border-left-width".equalsIgnoreCase(propertyName) || "border-right-width".equalsIgnoreCase(propertyName) || "border-top-width".equalsIgnoreCase(propertyName);
    }

    public Object getInitialValue(String propertyName, ICSSStyle style) {
        Object stylevalue = style.getStyleProperty("border-" + BorderWidthMeta.extractEdge(propertyName) + "-style");
        if ("none".equals(stylevalue) || "hidden".equals(stylevalue)) {
            return Length.LENGTH_0;
        }
        return super.getInitialValue(propertyName, style);
    }
}

