/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.html;

import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.CommandResources;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.dom.html.TableUtil;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TableDeleteHeaderFooterCommand
extends DesignerCommand {
    private Element _table;
    private boolean _isHeader;

    public TableDeleteHeaderFooterCommand(IHTMLGraphicalViewer viewer, Element table, boolean isHeader) {
        super(isHeader ? CommandResources.getString("TableDeleteHeaderFooterCommand.Label.DeleteHeader") : CommandResources.getString("TableDeleteHeaderFooterCommand.Label.DeleteFooter"), viewer);
        this._table = table;
        this._isHeader = isHeader;
    }

    public boolean canExecute() {
        String sectionName = this._isHeader ? "thead" : "tfoot";
        int rows = TableUtil.countSectionRows(this._table, sectionName);
        if (rows == 0) {
            return false;
        }
        return super.canExecute();
    }

    protected void doExecute() {
        String sectionName = this._isHeader ? "thead" : "tfoot";
        List list = DOMUtil.getChildElementsByTagIgnoreCase(this._table, sectionName);
        Node delNode = (Node)list.get(0);
        this._table.removeChild(delNode);
    }

    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._table);
    }
}

