/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.jpql;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.persistence.jpa.jpql.tools.ContentAssistProposals;
import org.eclipse.persistence.jpa.jpql.tools.ResultQuery;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

abstract class JpqlCompletionProposal
implements ICompletionProposal {
    private String additionalInfo;
    private int cursorOffset;
    private String displayString;
    private Image image;
    String jpqlQuery;
    private NamedQuery namedQuery;
    int position;
    String proposal;
    ContentAssistProposals proposals;
    ResultQuery result;
    boolean toggleCompletion;
    private int tokenEnd;
    private int tokenStart;

    JpqlCompletionProposal(ContentAssistProposals proposals, String proposal, String displayString, String additionalInfo, Image image, NamedQuery namedQuery, String jpqlQuery, int tokenStart, int tokenEnd, int position, int cursorOffset) {
        this.image = image;
        this.tokenStart = tokenStart;
        this.tokenEnd = tokenEnd;
        this.position = position;
        this.proposal = proposal;
        this.jpqlQuery = jpqlQuery;
        this.proposals = proposals;
        this.namedQuery = namedQuery;
        this.cursorOffset = cursorOffset;
        this.displayString = displayString;
        this.additionalInfo = additionalInfo;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.tokenStart, this.tokenEnd - this.tokenStart, this.getResult().getQuery());
        }
        catch (BadLocationException badLocationException) {}
    }

    abstract ResultQuery buildResult();

    public String getAdditionalProposalInfo() {
        return this.additionalInfo;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public Image getImage() {
        return this.image;
    }

    final ResultQuery getResult() {
        if (this.result == null) {
            this.result = this.buildResult();
        }
        return this.result;
    }

    public Point getSelection(IDocument document) {
        return new Point(this.tokenStart + this.getResult().getPosition() + this.cursorOffset, 0);
    }

    final boolean isCompletionInserts() {
        IJavaProject javaProject = this.namedQuery.getJpaProject().getJavaProject();
        String value = PreferenceConstants.getPreference((String)"content_assist_insert_completion", (IJavaProject)javaProject);
        return Boolean.valueOf(value);
    }

    public String toString() {
        return this.proposal;
    }
}

