/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.closure;

import org.eclipse.jpt.common.utility.Association;
import org.eclipse.jpt.common.utility.closure.Closure;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.factory.Factory;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.closure.ClosureWrapper;
import org.eclipse.jpt.common.utility.internal.closure.CommandClosure;
import org.eclipse.jpt.common.utility.internal.closure.CompositeClosure;
import org.eclipse.jpt.common.utility.internal.closure.ConditionalClosure;
import org.eclipse.jpt.common.utility.internal.closure.DisabledClosure;
import org.eclipse.jpt.common.utility.internal.closure.FactoryClosure;
import org.eclipse.jpt.common.utility.internal.closure.MethodClosure;
import org.eclipse.jpt.common.utility.internal.closure.NullCheckClosureWrapper;
import org.eclipse.jpt.common.utility.internal.closure.NullClosure;
import org.eclipse.jpt.common.utility.internal.closure.RepeatingClosure;
import org.eclipse.jpt.common.utility.internal.closure.SafeClosureWrapper;
import org.eclipse.jpt.common.utility.internal.closure.SwitchClosure;
import org.eclipse.jpt.common.utility.internal.closure.ThreadLocalClosure;
import org.eclipse.jpt.common.utility.internal.closure.TransformerClosure;
import org.eclipse.jpt.common.utility.internal.closure.UntilClosure;
import org.eclipse.jpt.common.utility.internal.closure.WhileClosure;
import org.eclipse.jpt.common.utility.internal.command.NullCommand;
import org.eclipse.jpt.common.utility.internal.exception.DefaultExceptionHandler;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public final class ClosureTools {
    public static <A> Closure<A> adapt(Command command) {
        return new CommandClosure(command);
    }

    public static <A> Closure<A> adapt(Factory<?> factory) {
        return new FactoryClosure(factory);
    }

    public static <A> Closure<A> adapt(Transformer<? super A, ?> transformer) {
        return new TransformerClosure<A>(transformer);
    }

    public static <A> ThreadLocalClosure<A> threadLocalClosure() {
        return ClosureTools.threadLocalClosure(NullClosure.instance());
    }

    public static <A> ThreadLocalClosure<A> threadLocalClosure(Closure<? super A> defaultClosure) {
        return new ThreadLocalClosure<A>(defaultClosure);
    }

    public static <A> Closure<A> nullCheck(Closure<? super A> closure) {
        return ClosureTools.nullCheck(closure, NullCommand.instance());
    }

    public static <A> Closure<A> nullCheck(Closure<? super A> closure, Command nullCommand) {
        return new NullCheckClosureWrapper<A>(closure, nullCommand);
    }

    public static <A> ClosureWrapper<A> wrap(Closure<? super A> closure) {
        return new ClosureWrapper<A>(closure);
    }

    public static <A> Closure<A> safe(Closure<? super A> closure) {
        return ClosureTools.safe(closure, DefaultExceptionHandler.instance());
    }

    public static <A> Closure<A> safe(Closure<? super A> closure, ExceptionHandler exceptionHandler) {
        return new SafeClosureWrapper<A>(closure, exceptionHandler);
    }

    public static <A> Closure<A> execute(String methodName) {
        return ClosureTools.execute(methodName, ClassTools.EMPTY_ARRAY, ObjectTools.EMPTY_OBJECT_ARRAY);
    }

    public static <A> Closure<A> execute(String methodName, Class<?> parameterType, Object argument) {
        return ClosureTools.execute(methodName, new Class[]{parameterType}, new Object[]{argument});
    }

    public static <A> Closure<A> execute(String methodName, Class<?>[] parameterTypes, Object[] arguments) {
        return new MethodClosure(methodName, parameterTypes, arguments);
    }

    public static <A> Closure<A> composite(Closure<? super A> ... closures) {
        return ClosureTools.composite(ArrayTools.iterable(closures));
    }

    public static <A> Closure<A> composite(Iterable<Closure<? super A>> closures) {
        return new CompositeClosure<A>(closures);
    }

    public static <A> Closure<A> conditionalClosure(Predicate<? super A> predicate, Closure<? super A> closure) {
        return ClosureTools.conditionalClosure(predicate, closure, NullClosure.instance());
    }

    public static <A> Closure<A> conditionalClosure(Predicate<? super A> predicate, Closure<? super A> trueClosure, Closure<? super A> falseClosure) {
        return new ConditionalClosure<A>(predicate, trueClosure, falseClosure);
    }

    public static <A> Closure<A> switchClosure(Iterable<Association<Predicate<? super A>, Closure<? super A>>> closures) {
        return ClosureTools.switchClosure(closures, NullClosure.instance());
    }

    public static <A> Closure<A> switchClosure(Iterable<Association<Predicate<? super A>, Closure<? super A>>> closures, Closure<? super A> defaultClosure) {
        return new SwitchClosure<A>(closures, defaultClosure);
    }

    public static <A> Closure<A> disabledClosure() {
        return DisabledClosure.instance();
    }

    public static <A> Closure<A> repeat(Closure<? super A> closure, int count) {
        return new RepeatingClosure<A>(closure, count);
    }

    public static <A> Closure<A> while_(Predicate<? super A> predicate, Closure<? super A> closure) {
        return new WhileClosure<A>(predicate, closure);
    }

    public static <A> Closure<A> until(Closure<? super A> closure, Predicate<? super A> predicate) {
        return new UntilClosure<A>(closure, predicate);
    }

    private ClosureTools() {
        throw new UnsupportedOperationException();
    }
}

