/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.parts;

import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeType;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.fx.nodes.GeometryNode;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.planar.ICurve;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.parts.AbstractFeedbackPart;
import org.eclipse.gef.mvc.fx.parts.DefaultSelectionFeedbackPartFactory;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IRootPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class SelectionFeedbackPart
extends AbstractFeedbackPart<GeometryNode<IGeometry>> {
    protected static final double DEFAULT_STROKE_WIDTH = 1.5;
    private Provider<? extends IGeometry> feedbackGeometryProvider;

    @Override
    protected GeometryNode<IGeometry> doCreateVisual() {
        GeometryNode feedbackVisual = new GeometryNode();
        feedbackVisual.setFill((Paint)Color.TRANSPARENT);
        feedbackVisual.setMouseTransparent(true);
        feedbackVisual.setManaged(false);
        feedbackVisual.setStrokeWidth(1.5);
        return feedbackVisual;
    }

    @Override
    public void doRefreshVisual(GeometryNode<IGeometry> visual) {
        Set anchorages = this.getAnchoragesUnmodifiable().keySet();
        if (anchorages.isEmpty()) {
            return;
        }
        IVisualPart anchorage = (IVisualPart)anchorages.iterator().next();
        IRootPart<Node> root = anchorage.getRoot();
        if (root == null) {
            return;
        }
        IViewer viewer = anchorage.getRoot().getViewer();
        if (viewer == null) {
            return;
        }
        IGeometry feedbackGeometry = this.getFeedbackGeometry();
        if (feedbackGeometry == null) {
            return;
        }
        if (feedbackGeometry instanceof ICurve) {
            visual.setStrokeType(StrokeType.CENTERED);
        } else {
            visual.setStrokeType(StrokeType.OUTSIDE);
        }
        visual.setGeometry(feedbackGeometry);
        ObservableList<IContentPart<? extends Node>> selected = ((SelectionModel)((Object)viewer.getAdapter(SelectionModel.class))).getSelectionUnmodifiable();
        if (selected != null && selected.size() > 0 && selected.get(0) == anchorage) {
            visual.setStroke((Paint)this.getPrimarySelectionColor());
        } else {
            visual.setStroke((Paint)this.getSecondarySelectionColor());
        }
    }

    protected IGeometry getFeedbackGeometry() {
        return NodeUtils.sceneToLocal((Node)((GeometryNode)this.getVisual()).getParent(), (IGeometry)((IGeometry)this.feedbackGeometryProvider.get()));
    }

    protected Color getPrimarySelectionColor() {
        Provider connectedColorProvider = (Provider)this.getViewer().getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<Color>>(){}, (String)"PRIMARY_SELECTION_FEEDBACK_COLOR_PROVIDER"));
        return connectedColorProvider == null ? DefaultSelectionFeedbackPartFactory.DEFAULT_PRIMARY_SELECTION_FEEDBACK_COLOR : (Color)connectedColorProvider.get();
    }

    protected Color getSecondarySelectionColor() {
        Provider connectedColorProvider = (Provider)this.getViewer().getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<Color>>(){}, (String)"SECONDARY_SELECTION_FEEDBACK_COLOR_PROVIDER"));
        return connectedColorProvider == null ? DefaultSelectionFeedbackPartFactory.DEFAULT_SECONDARY_SELECTION_FEEDBACK_COLOR : (Color)connectedColorProvider.get();
    }

    public void setGeometryProvider(Provider<? extends IGeometry> geometryProvider) {
        this.feedbackGeometryProvider = geometryProvider;
    }
}

