/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.contentassist;

import com.google.inject.Inject;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.DotGraph;
import org.eclipse.gef.dot.internal.language.dot.EdgeOp;
import org.eclipse.gef.dot.internal.language.dot.GraphType;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.templates.ContextTypeIdHelper;
import org.eclipse.xtext.ui.editor.templates.DefaultTemplateProposalProvider;

public class DotTemplateProposalProvider
extends DefaultTemplateProposalProvider {
    @Inject
    public DotTemplateProposalProvider(TemplateStore templateStore, ContextTypeRegistry registry, ContextTypeIdHelper helper) {
        super(templateStore, registry, helper);
    }

    protected TemplateProposal doCreateProposal(Template template, TemplateContext templateContext, ContentAssistContext context, Image image, int relevance) {
        block14: {
            block15: {
                String attributeName;
                EObject currentModel = context.getCurrentModel();
                if (this.isEdgeTemplate(template)) {
                    template = this.replaceOpVariable(currentModel, template);
                }
                if (!this.isHtmlLabelTemplate(template)) break block14;
                if (!(currentModel instanceof Attribute)) break block15;
                ID attributeNameID = ((Attribute)currentModel).getName();
                if (attributeNameID == null) break block14;
                switch (attributeName = attributeNameID.toValue()) {
                    case "xlabel": 
                    case "headlabel": 
                    case "taillabel": 
                    case "label": {
                        return super.doCreateProposal(template, templateContext, context, image, relevance);
                    }
                }
                return null;
            }
            return null;
        }
        return super.doCreateProposal(template, templateContext, context, image, relevance);
    }

    private boolean isEdgeTemplate(Template template) {
        return "edge".equals(template.getName());
    }

    private boolean isHtmlLabelTemplate(Template template) {
        return "HTMLLabel".equals(template.getName());
    }

    private Template replaceOpVariable(EObject currentModel, Template edgeTemplate) {
        DotGraph dotGraph = (DotGraph)EcoreUtil2.getContainerOfType((EObject)currentModel, DotGraph.class);
        boolean isDirected = dotGraph.getType() == GraphType.DIGRAPH;
        String edgeOp = isDirected ? EdgeOp.DIRECTED.toString() : EdgeOp.UNDIRECTED.toString();
        return new Template(edgeTemplate.getName(), edgeTemplate.getDescription(), edgeTemplate.getContextTypeId(), edgeTemplate.getPattern().replaceAll(Pattern.quote("${op}"), edgeOp), edgeTemplate.isAutoInsertable());
    }
}

