/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.contentassist;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.dot.internal.ui.language.DotActivator;
import org.eclipse.gef.dot.internal.ui.language.DotActivatorEx;
import org.eclipse.gef.dot.internal.ui.language.editor.DotEditorUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.XtextSourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;

public class DotProposalProviderDelegator {
    private Injector injector;

    public DotProposalProviderDelegator(String language) {
        this.injector = DotActivator.getInstance().getInjector(language);
    }

    public List<ConfigurableCompletionProposal> computeConfigurableCompletionProposals(String text, int cursorPosition) {
        ArrayList<ConfigurableCompletionProposal> configurableCompletionProposal = new ArrayList<ConfigurableCompletionProposal>();
        ICompletionProposal[] completionProposals = new ICompletionProposal[]{};
        try {
            completionProposals = this.computeCompletionProposals(text, cursorPosition);
        }
        catch (Exception e) {
            DotActivatorEx.logError(e);
        }
        ICompletionProposal[] iCompletionProposalArray = completionProposals;
        int n = completionProposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal completionProposal = iCompletionProposalArray[n2];
            if (completionProposal instanceof ConfigurableCompletionProposal) {
                configurableCompletionProposal.add((ConfigurableCompletionProposal)completionProposal);
            }
            ++n2;
        }
        return configurableCompletionProposal;
    }

    private ICompletionProposal[] computeCompletionProposals(String currentModelToParse, int cursorPosition) throws Exception {
        IXtextDocument xtextDocument = DotEditorUtils.getDocument(this.injector, currentModelToParse);
        return this.computeCompletionProposals(xtextDocument, cursorPosition);
    }

    private ICompletionProposal[] computeCompletionProposals(IXtextDocument xtextDocument, int cursorPosition) throws BadLocationException {
        Shell shell = new Shell();
        try {
            ICompletionProposal[] iCompletionProposalArray = this.computeCompletionProposals(xtextDocument, cursorPosition, shell);
            return iCompletionProposalArray;
        }
        finally {
            shell.dispose();
        }
    }

    private ICompletionProposal[] computeCompletionProposals(IXtextDocument xtextDocument, int cursorPosition, Shell shell) throws BadLocationException {
        XtextSourceViewerConfiguration configuration = this.get(XtextSourceViewerConfiguration.class);
        ISourceViewer sourceViewer = this.getSourceViewer(shell, xtextDocument, configuration);
        return this.computeCompletionProposals(xtextDocument, cursorPosition, configuration, sourceViewer);
    }

    private ICompletionProposal[] computeCompletionProposals(IXtextDocument xtextDocument, int cursorPosition, XtextSourceViewerConfiguration configuration, ISourceViewer sourceViewer) throws BadLocationException {
        String contentType;
        IContentAssistant contentAssistant = configuration.getContentAssistant(sourceViewer);
        IContentAssistProcessor processor = contentAssistant.getContentAssistProcessor(contentType = xtextDocument.getContentType(cursorPosition));
        if (processor != null) {
            return processor.computeCompletionProposals((ITextViewer)sourceViewer, cursorPosition);
        }
        return new ICompletionProposal[0];
    }

    private <T> T get(Class<T> clazz) {
        return (T)this.injector.getInstance(clazz);
    }

    private ISourceViewer getSourceViewer(Shell shell, IXtextDocument xtextDocument, XtextSourceViewerConfiguration configuration) {
        XtextSourceViewer.Factory factory = this.get(XtextSourceViewer.Factory.class);
        XtextSourceViewer sourceViewer = factory.createSourceViewer((Composite)shell, null, null, false, 0);
        sourceViewer.configure((SourceViewerConfiguration)configuration);
        sourceViewer.setDocument((IDocument)xtextDocument);
        return sourceViewer;
    }
}

