/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ui.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.ui.Messages;
import org.eclipse.emf.ecoretools.ui.views.AnalysisView;
import org.eclipse.emf.ecoretools.ui.views.EClassDescendentHierarchyContentProvider;
import org.eclipse.emf.ecoretools.ui.views.EClassHierarchyContentProvider;
import org.eclipse.emf.ecoretools.ui.views.EClassInformationLabelProvider;
import org.eclipse.emf.ecoretools.ui.views.FeatureContentProvider;
import org.eclipse.emf.ecoretools.ui.views.FeatureLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.WorkbenchJob;

public class EClassHierarchyView
extends AnalysisView {
    public static final String VIEW_ID = "org.eclipse.emf.ecoretools.internal.views.EClassHierarchyView";
    private static final int JOB_DELAY = 0;
    private SashForm splitter;
    private TreeViewer hierarchyTree;
    private TreeViewer featuresViewer;
    private FeatureLabelProvider featureLabelProvider;
    private SortDirection kind = SortDirection.ASCENDANT;
    private ISelectionChangedListener hierarchicalTreeSelectionChangedListener;
    private Job refreshHierarchyJob;
    private Job refreshFeaturesJob;

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.splitter = new SashForm(parent, 256);
        this.hierarchicalTreeSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EClassHierarchyView.this.doSelectionChanged(event);
            }
        };
        this.hierarchyTree = new TreeViewer((Composite)this.splitter, 772);
        this.hierarchyTree.addPostSelectionChangedListener(this.hierarchicalTreeSelectionChangedListener);
        this.hierarchyTree.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (EClassHierarchyView.this.refreshHierarchyJob != null) {
                    EClassHierarchyView.this.refreshHierarchyJob.cancel();
                }
                if (EClassHierarchyView.this.refreshFeaturesJob != null) {
                    EClassHierarchyView.this.refreshFeaturesJob.cancel();
                }
            }
        });
        EClassHierarchyView.prepareViewerForDragToSirius(this.hierarchyTree);
        this.setKind(SortDirection.ASCENDANT);
        this.featuresViewer = new TreeViewer((Composite)this.splitter, 768);
        this.featuresViewer.setContentProvider((IContentProvider)new FeatureContentProvider());
        this.featureLabelProvider = new FeatureLabelProvider();
        this.featuresViewer.setLabelProvider((IBaseLabelProvider)this.featureLabelProvider);
        this.refresh();
    }

    private void doSelectionChanged(SelectionChangedEvent event) {
        EObject selectedObject;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (selectedObject = this.getSelection((IStructuredSelection)selection)) != null) {
            this.refreshFeatures((EObject)this.findEClass(selectedObject));
        }
    }

    private void setKind(SortDirection hierarchyKind) {
        this.kind = hierarchyKind;
        this.hierarchyTree.setLabelProvider((IBaseLabelProvider)new EClassInformationLabelProvider());
        switch (this.kind) {
            case ASCENDANT: {
                this.hierarchyTree.setContentProvider((IContentProvider)new EClassHierarchyContentProvider());
                break;
            }
            case DESCENDANT: {
                this.hierarchyTree.setContentProvider((IContentProvider)new EClassDescendentHierarchyContentProvider());
                break;
            }
        }
    }

    @Override
    protected void refresh(EObject object) {
        this.refreshHierarchy(object);
    }

    private void refreshHierarchy(EObject object) {
        EClass selectedEClass;
        if (this.refreshHierarchyJob != null) {
            this.refreshHierarchyJob.cancel();
        }
        if ((selectedEClass = this.findEClass(object)) != null) {
            this.refreshHierarchyJob = this.createRefreshHierarchyJob(selectedEClass);
            this.refreshHierarchyJob.schedule(0L);
        }
    }

    private void refreshFeatures(EObject object) {
        EClass selectedEClass;
        if (this.refreshFeaturesJob != null) {
            this.refreshFeaturesJob.cancel();
        }
        if ((selectedEClass = this.findEClass(object)) != null) {
            this.refreshFeaturesJob = this.createRefreshFeaturesJob(selectedEClass);
            this.refreshFeaturesJob.schedule(0L);
        }
    }

    private EClass findEClass(EObject object) {
        if (object instanceof DSemanticDecorator) {
            object = ((DSemanticDecorator)object).getTarget();
        }
        if (!(object instanceof EClass)) {
            object = object.eClass();
        }
        return (EClass)object;
    }

    private Job createRefreshHierarchyJob(final EClass selection) {
        WorkbenchJob job = new WorkbenchJob(Messages.EClassHierarchyView_RefreshHierarchy){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (EClassHierarchyView.this.hierarchyTree.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    EClassHierarchyView.this.hierarchyTree.getControl().setRedraw(false);
                    EClassHierarchyView.this.hierarchyTree.setInput((Object)new EClass[]{selection});
                    EClassHierarchyView.this.hierarchyTree.refresh();
                    EClassHierarchyView.this.hierarchyTree.expandToLevel(2);
                    EClassHierarchyView.this.hierarchyTree.setSelection((ISelection)new StructuredSelection((Object)selection), true);
                }
                finally {
                    EClassHierarchyView.this.hierarchyTree.getControl().setRedraw(true);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        return job;
    }

    private Job createRefreshFeaturesJob(final EClass selection) {
        WorkbenchJob job = new WorkbenchJob(Messages.EClassHierarchyView_RefreshHierarchy){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (EClassHierarchyView.this.featuresViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    EClassHierarchyView.this.featuresViewer.getControl().setRedraw(false);
                    EClassHierarchyView.this.featuresViewer.setInput((Object)new EClass[]{selection});
                    EClassHierarchyView.this.featureLabelProvider.setSelection(selection);
                    EClassHierarchyView.this.featuresViewer.refresh();
                }
                finally {
                    EClassHierarchyView.this.featuresViewer.getControl().setRedraw(true);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        return job;
    }

    @Override
    protected void fillToolBar(IToolBarManager toolBar) {
        Action ascendantAction = new Action(Messages.EClassHierarchyView_Ascendant, 8){

            public void run() {
                EClassHierarchyView.this.setKind(SortDirection.ASCENDANT);
                EClassHierarchyView.this.refresh();
            }
        };
        ascendantAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.ecoretools.ui", (String)"icons/elcl16/super_co.gif"));
        ascendantAction.setChecked(true);
        Action descendantAction = new Action(Messages.EClassHierarchyView_Descendant, 8){

            public void run() {
                EClassHierarchyView.this.setKind(SortDirection.DESCENDANT);
                EClassHierarchyView.this.refresh();
            }
        };
        descendantAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.ecoretools.ui", (String)"icons/elcl16/sub_co.gif"));
        toolBar.add((IAction)ascendantAction);
        toolBar.add((IAction)descendantAction);
        super.fillToolBar(toolBar);
    }

    private static enum SortDirection {
        ASCENDANT,
        DESCENDANT;

    }
}

