/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifierOperation;
import org.eclipse.dltk.internal.corext.buildpath.IBuildpathInformationProvider;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.GenerateBuildPathActionGroup;
import org.eclipse.jface.viewers.IStructuredSelection;

public class EditFiltersOperation
extends BuildpathModifierOperation {
    private final IBuildpathInformationProvider fCPInformationProvider;
    private final BuildpathModifier.IBuildpathModifierListener fListener;

    public EditFiltersOperation(BuildpathModifier.IBuildpathModifierListener listener, IBuildpathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_tooltip, 4);
        this.fListener = listener;
        this.fCPInformationProvider = informationProvider;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        GenerateBuildPathActionGroup.EditFilterAction action = new GenerateBuildPathActionGroup.EditFilterAction();
        IStructuredSelection selection = this.fCPInformationProvider.getSelection();
        Object firstElement = selection.getFirstElement();
        action.selectionChanged(selection);
        action.run();
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(firstElement);
        if (this.fListener != null) {
            List entries = action.getBPListElements();
            this.fListener.buildpathEntryChanged(entries);
        }
        this.fCPInformationProvider.handleResult(l, null, 4);
    }

    @Override
    public boolean isValid(List elements, int[] types) throws ModelException {
        if (elements.size() != 1) {
            return false;
        }
        IScriptProject project = this.fInformationProvider.getScriptProject();
        Object element = elements.get(0);
        if (element instanceof IScriptProject) {
            if (EditFiltersOperation.isSourceFolder(project)) {
                return true;
            }
        } else if (element instanceof IProjectFragment) {
            return ((IProjectFragment)element).getKind() == 1;
        }
        return false;
    }

    @Override
    public String getDescription(int type) {
        if (type == 1) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Edit;
        }
        if (type == 2) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Edit;
        }
        if (type == 14) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Edit;
        }
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_Edit;
    }
}

