/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.structure.builders;

import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.structure.AbstractTclCommandModelBuilder;
import org.eclipse.dltk.tcl.structure.ITclModelBuildContext;
import org.eclipse.dltk.tcl.structure.TclProcessorUtil;

public class TclPackageModelBuilder
extends AbstractTclCommandModelBuilder {
    @Override
    public boolean process(TclCommand command, ITclModelBuildContext context) {
        if (command.getArguments().isEmpty()) {
            return false;
        }
        String subcmd = TclProcessorUtil.asString((TclArgument)command.getArguments().get(0));
        if ("require".equals(subcmd)) {
            return this.processRequire(command, context);
        }
        if ("provide".equals(subcmd)) {
            return this.proccessProvide(command, context);
        }
        if ("ifneeded".equals(subcmd)) {
            return this.processIfNeeded(command, context);
        }
        return false;
    }

    private boolean processRequire(TclCommand command, ITclModelBuildContext context) {
        int index = 1;
        if (command.getArguments().size() <= index) {
            return false;
        }
        TclArgument pkg = (TclArgument)command.getArguments().get(index);
        String packageName = TclProcessorUtil.asString(pkg);
        if ("-exact".equals(packageName)) {
            if (command.getArguments().size() <= ++index) {
                return false;
            }
            pkg = (TclArgument)command.getArguments().get(index);
            packageName = TclProcessorUtil.asString(pkg);
        }
        IElementRequestor.ImportInfo importInfo = new IElementRequestor.ImportInfo();
        importInfo.sourceStart = pkg.getStart();
        importInfo.sourceEnd = pkg.getEnd();
        importInfo.containerName = "require";
        importInfo.name = packageName;
        if (command.getArguments().size() > index + 1) {
            TclArgument version = (TclArgument)command.getArguments().get(index + 1);
            importInfo.version = TclProcessorUtil.asString(version);
        }
        --importInfo.sourceEnd;
        context.getRequestor().acceptImport(importInfo);
        return false;
    }

    private boolean proccessProvide(TclCommand command, ITclModelBuildContext context) {
        if (command.getArguments().size() < 2) {
            return false;
        }
        TclArgument pkg = (TclArgument)command.getArguments().get(1);
        int start = pkg.getStart();
        int end = pkg.getEnd();
        String packageName = TclProcessorUtil.asString(pkg);
        if (command.getArguments().size() > 2) {
            TclArgument version = (TclArgument)command.getArguments().get(2);
            packageName = String.valueOf(packageName) + " (" + TclProcessorUtil.asString(version) + ")";
        }
        context.getRequestor().acceptPackage(start, end - 1, packageName);
        return false;
    }

    private boolean processIfNeeded(TclCommand command, ITclModelBuildContext context) {
        if (command.getArguments().size() < 2) {
            return false;
        }
        TclArgument pkg = (TclArgument)command.getArguments().get(1);
        int start = pkg.getStart();
        int end = pkg.getEnd();
        String packageName = TclProcessorUtil.asString(pkg);
        if (command.getArguments().size() > 2) {
            TclArgument version = (TclArgument)command.getArguments().get(2);
            packageName = String.valueOf(packageName) + " (" + TclProcessorUtil.asString(version) + ")";
        }
        context.getRequestor().acceptPackage(start, end - 1, String.valueOf(packageName) + "*");
        return false;
    }
}

