/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.core;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.core.Messages;
import org.eclipse.dltk.tcl.core.TclPlugin;
import org.eclipse.osgi.util.NLS;

class RebuildProjectsJob
extends Job {
    private final IInterpreterInstall install;

    public RebuildProjectsJob(IInterpreterInstall install) {
        super(NLS.bind((String)Messages.AddTclInterpreterDialog_RebuildJobName, (Object)install.getName()));
        this.install = install;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IScriptProject[] projects;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            projects = DLTKCore.create((IWorkspaceRoot)root).getScriptProjects("org.eclipse.dltk.tcl.core.nature");
        }
        catch (ModelException e) {
            TclPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.dltk.tcl.core", e.getMessage(), (Throwable)e));
            return e.getStatus();
        }
        subMonitor.worked(20);
        SubMonitor buildingMonitor = subMonitor.newChild(80);
        buildingMonitor.beginTask(Messages.AddTclInterpreterDialog_RebuildProjectsTaskName, projects.length);
        int i = 0;
        while (i < projects.length) {
            IScriptProject project = projects[i];
            try {
                this.bulidProject(project, buildingMonitor.newChild(1));
            }
            catch (CoreException e) {
                TclPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.dltk.tcl.core", e.getMessage(), (Throwable)e));
            }
            ++i;
        }
        subMonitor.done();
        return Status.OK_STATUS;
    }

    private void bulidProject(IScriptProject project, SubMonitor monitor) throws CoreException {
        IInterpreterInstall projectInterpreterInstall = ScriptRuntime.getInterpreterInstall((IScriptProject)project);
        if (projectInterpreterInstall != null && projectInterpreterInstall.equals(this.install)) {
            monitor.setTaskName(NLS.bind((String)Messages.AddTclInterpreterDialog_RebuildProjectTaskName, (Object)project.getElementName()));
            project.getProject().build(6, (IProgressMonitor)monitor);
        }
    }
}

