/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import org.eclipse.dltk.launching.AbstractInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.IInterpreterRunner;
import org.eclipse.dltk.launching.ScriptRuntime;

public class InterpreterStandin
extends AbstractInterpreterInstall {
    public InterpreterStandin(IInterpreterInstallType type, String id) {
        super(type, id);
        this.setNotify(false);
    }

    public InterpreterStandin(IInterpreterInstall sourceInterpreter, String id) {
        super(sourceInterpreter.getInterpreterInstallType(), id);
        this.setNotify(false);
        this.init(sourceInterpreter);
    }

    public InterpreterStandin(IInterpreterInstall realInterpreter) {
        this(realInterpreter.getInterpreterInstallType(), realInterpreter.getId());
        this.init(realInterpreter);
    }

    private void init(IInterpreterInstall realInterpreter) {
        this.setName(realInterpreter.getName());
        this.setInstallLocation(realInterpreter.getRawInstallLocation());
        this.setLibraryLocations(realInterpreter.getLibraryLocations());
        this.setInterpreterArgs(realInterpreter.getInterpreterArgs());
        this.setEnvironmentVariables(realInterpreter.getEnvironmentVariables());
        this.setExtensions(realInterpreter.copyExtensions());
    }

    public IInterpreterInstall convertToRealInterpreter() {
        IInterpreterInstallType installType = this.getInterpreterInstallType();
        IInterpreterInstall realInterpreter = installType.findInterpreterInstall(this.getId());
        boolean notify = true;
        if (realInterpreter == null) {
            realInterpreter = installType.createInterpreterInstall(this.getId());
            notify = false;
        }
        if (realInterpreter instanceof AbstractInterpreterInstall) {
            ((AbstractInterpreterInstall)realInterpreter).setNotify(notify);
        }
        realInterpreter.setName(this.getName());
        realInterpreter.setInstallLocation(this.getRawInstallLocation());
        realInterpreter.setLibraryLocations(this.getLibraryLocations());
        realInterpreter.setEnvironmentVariables(this.getEnvironmentVariables());
        realInterpreter.setInterpreterArgs(this.getInterpreterArgs());
        realInterpreter.setExtensions(this.copyExtensions());
        if (realInterpreter instanceof AbstractInterpreterInstall) {
            ((AbstractInterpreterInstall)realInterpreter).setNotify(true);
        }
        if (!notify) {
            ScriptRuntime.fireInterpreterAdded(realInterpreter);
        }
        return realInterpreter;
    }

    @Override
    public IInterpreterRunner getInterpreterRunner(String mode) {
        return null;
    }

    @Override
    public String getNatureId() {
        return this.getInterpreterInstallType().getNatureId();
    }
}

