/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.sql;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.sql.AbstractSQLEditorTextHover;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class SQLAnnotationHover
extends AbstractSQLEditorTextHover
implements ITextHover,
IAnnotationHover,
ITextHoverExtension {
    private ArrayList _fAnnotations = new ArrayList();
    private IEditorPart fEditor;

    public SQLAnnotationHover(IEditorPart editor) {
        this.setEditor(editor);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String text;
        IAnnotationModel model = null;
        IAnnotationModel iAnnotationModel = model = textViewer instanceof ISourceViewer ? ((ISourceViewer)textViewer).getAnnotationModel() : null;
        if (this._fAnnotations.size() == 0) {
            this.findAnnotations(hoverRegion.getOffset(), model, null, 0);
        }
        return (text = this.getHoverInfo()) != null ? text.toString() : null;
    }

    @Override
    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        IDocument document = textViewer.getDocument();
        int start = 0;
        int end = 0;
        int lineNumber = 0;
        try {
            lineNumber = document.getLineOfOffset(offset);
        }
        catch (BadLocationException e) {
            SQLEditorPlugin.getDefault().log(e);
        }
        this.findAnnotations(offset, textViewer instanceof ISourceViewer ? ((ISourceViewer)textViewer).getAnnotationModel() : null, textViewer.getDocument(), lineNumber);
        int i = 0;
        while (i < this._fAnnotations.size()) {
            Annotation annotation = (Annotation)this._fAnnotations.get(i);
            if (annotation instanceof MarkerAnnotation) {
                MarkerAnnotation markerAnnotation = (MarkerAnnotation)annotation;
                try {
                    start = (Integer)markerAnnotation.getMarker().getAttribute("charStart");
                    end = (Integer)markerAnnotation.getMarker().getAttribute("charEnd");
                    if (start <= offset && end >= offset) {
                        return new Region(offset, 0);
                    }
                }
                catch (CoreException e1) {
                    SQLEditorPlugin.getDefault().log(e1);
                }
            }
            ++i;
        }
        return null;
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        String text;
        if (this._fAnnotations.size() == 0) {
            this.findAnnotations(-1, sourceViewer.getAnnotationModel(), sourceViewer.getDocument(), lineNumber);
        }
        return (text = this.getHoverInfo()) != null ? text.toString() : null;
    }

    private void findAnnotations(int offset, IAnnotationModel model, IDocument document, int lineNumber) {
        this._fAnnotations.clear();
        if (model == null && this.fEditor instanceof ITextEditor) {
            ITextEditor editor = (ITextEditor)this.fEditor;
            model = editor.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
        }
        if (model == null) {
            return;
        }
        Iterator it = model.getAnnotationIterator();
        while (it.hasNext()) {
            Annotation annotation = (Annotation)it.next();
            Position position = model.getPosition(annotation);
            if (position == null) {
                return;
            }
            try {
                if (!position.overlapsWith(offset, 1) && (document == null || document.getLineOfOffset(position.offset) != lineNumber)) continue;
                this._fAnnotations.add(annotation);
            }
            catch (BadLocationException e) {
                SQLEditorPlugin.getDefault().log(e);
            }
        }
    }

    private String getHoverInfo() {
        String text = null;
        IPreferenceStore store = SQLEditorPlugin.getDefault().getPreferenceStore();
        int i = 0;
        while (i < this._fAnnotations.size()) {
            Annotation annotation = (Annotation)this._fAnnotations.get(i);
            if (annotation instanceof MarkerAnnotation) {
                try {
                    IMarker marker = ((MarkerAnnotation)annotation).getMarker();
                    if (marker.getType().equals("org.eclipse.datatools.sqltools.sqleditor.syntaxproblem") || marker.getType().equals("org.eclipse.datatools.sqltools.sqleditor.portabilitytask")) {
                        if (store.getBoolean("show.syntax.error.detail")) {
                            text = (String)marker.getAttribute("message");
                            break;
                        }
                        text = (String)marker.getAttribute("short_message");
                        break;
                    }
                }
                catch (CoreException e) {
                    SQLEditorPlugin.getDefault().log(e);
                }
            }
            ++i;
        }
        this._fAnnotations.clear();
        return text;
    }

    @Override
    public void setEditor(IEditorPart editor) {
        this.fEditor = editor;
    }
}

