/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.session;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.tests.session.ProcessController;
import org.eclipse.core.tests.session.SetupManager;

public class Setup
implements Cloneable {
    public static final String APPLICATION = "application";
    private static final String ARCH = "arch";
    public static final String CONFIGURATION = "configuration";
    public static final String DATA = "data";
    public static final String DEBUG = "debug";
    private static final int DEFAULT_TIMEOUT = 0;
    public static final String DEV = "dev";
    public static final String INSTALL = "install";
    private static final String NL = "nl";
    private static final String OS = "os";
    public static final String VM = "vm";
    private static final String WS = "ws";
    private static final String PROP_BOOT_DELEGATION = "org.osgi.framework.bootdelegation";
    private String[] baseSetups;
    private HashMap<String, String> eclipseArguments = new HashMap();
    private String id;
    private SetupManager manager;
    private String name;
    private String[] requiredSets;
    private HashMap<String, String> systemProperties = new HashMap();
    private int timeout;
    private HashMap<String, String> vmArguments = new HashMap();

    public static String getDefaultArchOption() {
        return System.getProperty("osgi.arch");
    }

    public static String getDefaultConfiguration() {
        return System.getProperty("osgi.configuration.area");
    }

    public static String getDefaultDebugOption() {
        return System.getProperty("osgi.debug");
    }

    public static String getDefaultDevOption() {
        return System.getProperty("osgi.dev");
    }

    public static String getDefaultInstallLocation() {
        String currentInstall = System.getProperty("osgi.install.area");
        if (currentInstall != null) {
            try {
                return new URI(currentInstall).getPath();
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return null;
    }

    public static String getDefaultInstanceLocation() {
        return new File(System.getProperty("java.io.tmpdir"), "workspace").toString();
    }

    public static String getDefaultNLOption() {
        return System.getProperty("osgi.nl");
    }

    public static String getDefaultOSOption() {
        return System.getProperty("osgi.os");
    }

    static Setup getDefaultSetup(SetupManager manager) {
        String defaultOS;
        Setup defaultSetup = new Setup(manager);
        defaultSetup.setSystemProperty(PROP_BOOT_DELEGATION, System.getProperty(PROP_BOOT_DELEGATION));
        defaultSetup.setSystemProperty("eclipse.consoleLog", System.getProperty("eclipse.consoleLog", "true"));
        if (Setup.getDefaultVMLocation() != null) {
            defaultSetup.setEclipseArgument(VM, Setup.getDefaultVMLocation());
        }
        if (Setup.getDefaultConfiguration() != null) {
            defaultSetup.setEclipseArgument(CONFIGURATION, Setup.getDefaultConfiguration());
        }
        if (Setup.getDefaultDebugOption() != null) {
            defaultSetup.setSystemProperty("osgi.debug", Setup.getDefaultDebugOption());
        }
        if (Setup.getDefaultDevOption() != null) {
            defaultSetup.setEclipseArgument(DEV, Setup.getDefaultDevOption());
        }
        if (Setup.getDefaultInstallLocation() != null) {
            defaultSetup.setEclipseArgument(INSTALL, Setup.getDefaultInstallLocation());
        }
        if (Setup.getDefaultInstanceLocation() != null) {
            defaultSetup.setEclipseArgument(DATA, Setup.getDefaultInstanceLocation());
        }
        if (Setup.getDefaultArchOption() != null) {
            defaultSetup.setEclipseArgument(ARCH, Setup.getDefaultArchOption());
        }
        if ((defaultOS = Setup.getDefaultOSOption()) != null) {
            defaultSetup.setEclipseArgument(OS, defaultOS);
            if ("macosx".equals(defaultOS)) {
                defaultSetup.setVMArgument("XstartOnFirstThread", "");
            }
        }
        if (Setup.getDefaultWSOption() != null) {
            defaultSetup.setEclipseArgument(WS, Setup.getDefaultWSOption());
        }
        if (Setup.getDefaultNLOption() != null) {
            defaultSetup.setEclipseArgument(NL, Setup.getDefaultNLOption());
        }
        defaultSetup.setTimeout(0);
        return defaultSetup;
    }

    public static String getDefaultVMLocation() {
        String javaVM = System.getProperty("eclipse.vm");
        if (javaVM != null) {
            return javaVM;
        }
        javaVM = System.getProperty("java.home");
        if (javaVM == null) {
            return null;
        }
        return new File(new File(javaVM, "bin"), "java").toString();
    }

    public static String getDefaultWSOption() {
        return System.getProperty("osgi.ws");
    }

    public Setup(SetupManager manager) {
        this.manager = manager;
    }

    public Object clone() {
        Setup clone = null;
        try {
            clone = (Setup)super.clone();
            clone.eclipseArguments = new HashMap<String, String>(this.eclipseArguments);
            clone.vmArguments = new HashMap<String, String>(this.vmArguments);
            clone.systemProperties = new HashMap<String, String>(this.systemProperties);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    private void fillClassPath(List<String> params) {
        if (this.vmArguments.containsKey("cp") || this.vmArguments.containsKey("classpath")) {
            return;
        }
        String inheritedClassPath = System.getProperty("java.class.path");
        if (inheritedClassPath == null) {
            String installLocation = this.getEclipseArgument(INSTALL);
            if (installLocation == null) {
                throw new IllegalStateException("Classpath could not be computed");
            }
            inheritedClassPath = new File(installLocation, "startup.jar").toString();
        }
        params.add("-classpath");
        params.add(inheritedClassPath);
    }

    public void fillCommandLine(List<String> commandLine) {
        String vmLocation = this.getEclipseArgument(VM);
        if (vmLocation == null) {
            throw new IllegalStateException("VM location not set");
        }
        commandLine.add(vmLocation);
        this.fillClassPath(commandLine);
        this.fillVMArgs(commandLine);
        this.fillSystemProperties(commandLine);
        commandLine.add("org.eclipse.core.launcher.Main");
        this.fillEclipseArgs(commandLine);
    }

    private void fillEclipseArgs(List<String> params) {
        for (Map.Entry<String, String> entry : this.eclipseArguments.entrySet()) {
            params.add(String.valueOf('-') + entry.getKey());
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            params.add(entry.getValue());
        }
    }

    private void fillSystemProperties(List<String> command) {
        for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
            if (entry.getValue() == null) continue;
            StringBuilder property = new StringBuilder("-D");
            property.append(entry.getKey());
            if (!entry.getValue().isEmpty()) {
                property.append('=');
                property.append(entry.getValue());
            }
            command.add(property.toString());
        }
    }

    private void fillVMArgs(List<String> params) {
        for (Map.Entry<String, String> entry : this.vmArguments.entrySet()) {
            params.add(String.valueOf('-') + entry.getKey());
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            params.add(entry.getValue());
        }
    }

    String[] getBaseSetups() {
        return this.baseSetups;
    }

    public String[] getCommandLine() {
        ArrayList<String> commandLine = new ArrayList<String>();
        this.fillCommandLine(commandLine);
        return commandLine.toArray(new String[commandLine.size()]);
    }

    public String getEclipseArgsLine() {
        ArrayList<String> eclipseArgs = new ArrayList<String>();
        this.fillEclipseArgs(eclipseArgs);
        StringBuilder result = new StringBuilder();
        for (String string : eclipseArgs) {
            result.append(string);
            result.append(' ');
        }
        return result.length() > 0 ? result.substring(0, result.length() - 1) : null;
    }

    public String getEclipseArgument(String key) {
        return this.eclipseArguments.get(key);
    }

    public Map<String, String> getEclipseArguments() {
        return new HashMap<String, String>(this.eclipseArguments);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    String[] getRequiredSets() {
        return this.requiredSets;
    }

    public Map<String, String> getSystemProperties() {
        return new HashMap<String, String>(this.systemProperties);
    }

    public String getSystemPropertiesLine() {
        ArrayList<String> sysProperties = new ArrayList<String>();
        this.fillSystemProperties(sysProperties);
        StringBuilder result = new StringBuilder();
        for (String string : sysProperties) {
            result.append(string);
            result.append(' ');
        }
        return result.length() > 0 ? result.substring(0, result.length() - 1) : null;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getVMArgsLine() {
        ArrayList<String> vmArgs = new ArrayList<String>();
        this.fillVMArgs(vmArgs);
        StringBuilder result = new StringBuilder();
        for (String string : vmArgs) {
            result.append(string);
            result.append(' ');
        }
        return result.length() > 0 ? result.substring(0, result.length() - 1) : null;
    }

    public String getVMArgument(String key) {
        return this.vmArguments.get(key);
    }

    public Map<String, String> getVMArguments() {
        return new HashMap<String, String>(this.vmArguments);
    }

    public boolean isA(String baseOptionSet) {
        if (baseOptionSet.equals(this.id)) {
            return true;
        }
        if (this.baseSetups == null) {
            return false;
        }
        String[] stringArray = this.baseSetups;
        int n = this.baseSetups.length;
        int n2 = 0;
        while (n2 < n) {
            String baseSetup = stringArray[n2];
            Setup base = this.manager.getSetup(baseSetup);
            if (base != null && base.isA(baseOptionSet)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isSatisfied(String[] availableSets) {
        String[] stringArray = this.requiredSets;
        int n = this.requiredSets.length;
        int n2 = 0;
        while (n2 < n) {
            String requiredSet = stringArray[n2];
            boolean satisfied = false;
            int j = 0;
            while (!satisfied && j < availableSets.length) {
                Setup available = this.manager.getSetup(availableSets[j]);
                if (available != null && available.isA(requiredSet)) {
                    satisfied = true;
                }
                ++j;
            }
            if (!satisfied) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void merge(Setup variation) {
        this.eclipseArguments.putAll(variation.eclipseArguments);
        this.vmArguments.putAll(variation.vmArguments);
        this.systemProperties.putAll(variation.systemProperties);
    }

    public int run() throws InterruptedException, IOException, ProcessController.TimeOutException {
        if (SetupManager.inDebugMode()) {
            System.out.print("Command line: ");
            System.out.println(this.toCommandLineString());
        }
        ProcessController process = new ProcessController(this.getTimeout(), this.getCommandLine());
        process.forwardErrorOutput(System.err);
        process.forwardOutput(System.out);
        return process.execute();
    }

    void setBaseSetups(String[] baseSetups) {
        this.baseSetups = baseSetups;
    }

    public void setEclipseArgument(String key, String value) {
        if (value == null) {
            this.eclipseArguments.remove(key);
        } else {
            this.eclipseArguments.put(key, value);
        }
    }

    public void setEclipseArguments(Map<String, String> newArguments) {
        if (newArguments == null) {
            this.eclipseArguments.clear();
        } else {
            this.eclipseArguments.putAll(newArguments);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    void setRequiredSets(String[] requiredSets) {
        this.requiredSets = requiredSets;
    }

    public void setSystemProperties(Map<String, String> newProperties) {
        if (newProperties == null) {
            this.systemProperties.clear();
        } else {
            this.systemProperties.putAll(newProperties);
        }
    }

    public void setSystemProperty(String key, String value) {
        if (value == null) {
            this.systemProperties.remove(key);
        } else {
            this.systemProperties.put(key, value);
        }
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setVMArgument(String key, String value) {
        if (value == null) {
            this.vmArguments.remove(key);
        } else {
            this.vmArguments.put(key, value);
        }
    }

    public void setVMArguments(Map<String, String> newArguments) {
        if (newArguments == null) {
            this.vmArguments.clear();
        } else {
            this.vmArguments.putAll(newArguments);
        }
    }

    public String toCommandLineString() {
        String[] commandLine = this.getCommandLine();
        StringBuilder result = new StringBuilder();
        result.append("[\n");
        String[] stringArray = commandLine;
        int n = commandLine.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            result.append('\t');
            result.append(element);
            result.append('\n');
            ++n2;
        }
        result.append(']');
        return result.toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.id != null || this.name != null) {
            if (this.id != null) {
                result.append(this.id);
                result.append(' ');
            }
            if (this.name != null && this.name != null) {
                result.append("(");
                result.append(this.name);
                result.append(") ");
            }
            result.append("= ");
        }
        result.append("[");
        result.append("\n\teclipseArguments: ");
        result.append(this.eclipseArguments);
        result.append("\n\tvmArguments: ");
        result.append(this.vmArguments);
        result.append("\n\tsystemProperties: ");
        result.append(this.systemProperties);
        result.append("\n]");
        return result.toString();
    }
}

