/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable.primitive;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.factory.list.primitive.MutableByteListFactory;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.impl.factory.primitive.ByteLists;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableByteListFactoryImpl implements MutableByteListFactory
{
    INSTANCE;


    @Override
    public MutableByteList empty() {
        return new ByteArrayList();
    }

    @Override
    public MutableByteList of() {
        return this.empty();
    }

    @Override
    public MutableByteList with() {
        return this.empty();
    }

    @Override
    public MutableByteList withInitialCapacity(int capacity) {
        return new ByteArrayList(capacity);
    }

    @Override
    public MutableByteList of(byte ... items) {
        return this.with(items);
    }

    @Override
    public MutableByteList with(byte ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        return ByteArrayList.newListWith(items);
    }

    @Override
    public MutableByteList ofAll(ByteIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableByteList withAll(ByteIterable items) {
        return ByteArrayList.newList(items);
    }

    @Override
    public MutableByteList ofAll(Iterable<Byte> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableByteList withAll(Iterable<Byte> iterable) {
        return Iterate.collectByte(iterable, Byte::byteValue, ByteLists.mutable.empty());
    }
}

