/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.gettersandsetters;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.corext.codemanipulation.StubUtility;

public class GetterSetterNameGenerator {
    private static Set<String> generateGetterSettersPreferenceKeys = new HashSet<String>();

    static {
        generateGetterSettersPreferenceKeys.add("nameStyle.getter.capitalization");
        generateGetterSettersPreferenceKeys.add("nameStyle.getter.wordDelimiter");
        generateGetterSettersPreferenceKeys.add("nameStyle.getter.prefixForBoolean");
        generateGetterSettersPreferenceKeys.add("nameStyle.getter.prefix");
        generateGetterSettersPreferenceKeys.add("nameStyle.getter.suffix");
        generateGetterSettersPreferenceKeys.add("nameStyle.setter.capitalization");
        generateGetterSettersPreferenceKeys.add("nameStyle.setter.wordDelimiter");
        generateGetterSettersPreferenceKeys.add("nameStyle.setter.prefix");
        generateGetterSettersPreferenceKeys.add("nameStyle.setter.suffix");
        generateGetterSettersPreferenceKeys.add("nameStyle.variable.capitalization");
        generateGetterSettersPreferenceKeys.add("nameStyle.variable.wordDelimiter");
        generateGetterSettersPreferenceKeys.add("nameStyle.variable.prefix");
        generateGetterSettersPreferenceKeys.add("nameStyle.variable.suffix");
    }

    private GetterSetterNameGenerator() {
    }

    public static Set<String> getGenerateGetterSettersPreferenceKeys() {
        return generateGetterSettersPreferenceKeys;
    }

    public static String generateGetterName(IASTName fieldName, Set<String> namesToAvoid) {
        ITranslationUnit tu = GetterSetterNameGenerator.getTranslationUnit((IASTNode)fieldName);
        return StubUtility.suggestGetterName(StubUtility.trimFieldName(fieldName.toString()), GetterSetterNameGenerator.isBooleanDeclaratorName(fieldName), namesToAvoid, tu);
    }

    private static boolean isBooleanDeclaratorName(IASTName name) {
        if (IASTDeclarator.DECLARATOR_NAME.equals(name.getPropertyInParent())) {
            IASTDeclarator declarator = (IASTDeclarator)name.getParent();
            IType type = CPPVisitor.createType((IASTDeclarator)declarator);
            if ((type = SemanticUtil.getNestedType((IType)type, (int)9)) instanceof IBasicType && ((IBasicType)type).getKind() == IBasicType.Kind.eBoolean) {
                return true;
            }
        }
        return false;
    }

    public static String generateSetterName(IASTName fieldName, Set<String> namesToAvoid) {
        ITranslationUnit tu = GetterSetterNameGenerator.getTranslationUnit((IASTNode)fieldName);
        return StubUtility.suggestSetterName(StubUtility.trimFieldName(fieldName.toString()), namesToAvoid, tu);
    }

    public static String generateSetterParameterName(IASTName fieldName) {
        ITranslationUnit tu = GetterSetterNameGenerator.getTranslationUnit((IASTNode)fieldName);
        return StubUtility.suggestParameterName(StubUtility.trimFieldName(fieldName.toString()), null, tu);
    }

    private static ITranslationUnit getTranslationUnit(IASTNode node) {
        return node.getTranslationUnit().getOriginatingTranslationUnit();
    }
}

