/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.internal.corext.codemanipulation.IncludeInfo;
import org.eclipse.cdt.internal.ui.dialogs.ResizableStatusDialog;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.preferences.HeaderSubstitutionEditDialog;
import org.eclipse.cdt.internal.ui.preferences.HeaderSubstitutionRule;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.refactoring.includes.HeaderSubstitutionMap;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeMap;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;

public class HeaderSubstitutionMapEditDialog
extends ResizableStatusDialog {
    private static final String UTF_8 = "UTF-8";
    private static final String TAG_HEADER_SUBSTITUTION_MAP = "header_substitution_map";
    private static final Collator COLLATOR = Collator.getInstance();
    private static final Comparator<HeaderSubstitutionRule> SOURCE_COMPARATOR = new Comparator<HeaderSubstitutionRule>(){

        @Override
        public int compare(HeaderSubstitutionRule r1, HeaderSubstitutionRule r2) {
            return COLLATOR.compare(r1.getSource(), r2.getSource());
        }
    };
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private static final int IDX_UP = 3;
    private static final int IDX_DOWN = 4;
    private final StringDialogField fNameField;
    private final ComboDialogField fAppliesToField;
    private final HeaderSubstitutionListField fUnconditionalSubstitutionsField;
    private final HeaderSubstitutionListField fOptionalSubstitutionsField;
    private final Set<String> fExistingNames = new HashSet<String>();
    private final boolean fNewMap;

    public HeaderSubstitutionMapEditDialog(Shell parent, HeaderSubstitutionMap map, List<HeaderSubstitutionMap> existingEntries) {
        super(parent);
        for (HeaderSubstitutionMap exising : existingEntries) {
            if (exising.equals(map)) continue;
            this.fExistingNames.add(exising.getName());
        }
        if (map == null) {
            this.fNewMap = true;
            this.setTitle(PreferencesMessages.HeaderSubstitutionMapEditDialog_new_title);
        } else {
            this.fNewMap = false;
            this.setTitle(PreferencesMessages.HeaderSubstitutionMapEditDialog_edit_title);
        }
        ListAdapter adapter = new ListAdapter();
        this.fNameField = new StringDialogField();
        this.fNameField.setLabelText(PreferencesMessages.HeaderSubstitutionMapEditDialog_name);
        this.fNameField.setDialogFieldListener(adapter);
        String[] items = new String[]{PreferencesMessages.HeaderSubstitutionMapEditDialog_c_and_cpp, PreferencesMessages.HeaderSubstitutionMapEditDialog_cpp_only};
        this.fAppliesToField = new ComboDialogField(8);
        this.fAppliesToField.setLabelText(PreferencesMessages.HeaderSubstitutionMapEditDialog_applies_to);
        this.fAppliesToField.setItems(items);
        String[] buttons = new String[]{PreferencesMessages.HeaderSubstitutionMapEditDialog_add_button, PreferencesMessages.HeaderSubstitutionMapEditDialog_edit_button, PreferencesMessages.HeaderSubstitutionMapEditDialog_remove_button};
        this.fUnconditionalSubstitutionsField = new HeaderSubstitutionListField(adapter, buttons);
        this.fUnconditionalSubstitutionsField.setLabelText(PreferencesMessages.HeaderSubstitutionMapEditDialog_required_substitution);
        this.fUnconditionalSubstitutionsField.setDialogFieldListener(adapter);
        String[] columnsHeaders = new String[]{PreferencesMessages.HeaderSubstitutionMapEditDialog_header, PreferencesMessages.HeaderSubstitutionMapEditDialog_replacement};
        this.fUnconditionalSubstitutionsField.setTableColumns(new ListDialogField.ColumnsDescription(columnsHeaders, true));
        buttons = new String[]{PreferencesMessages.HeaderSubstitutionMapEditDialog_add_button2, PreferencesMessages.HeaderSubstitutionMapEditDialog_edit_button2, PreferencesMessages.HeaderSubstitutionMapEditDialog_remove_button2, PreferencesMessages.HeaderSubstitutionMapEditDialog_up_button, PreferencesMessages.HeaderSubstitutionMapEditDialog_down_button};
        this.fOptionalSubstitutionsField = new HeaderSubstitutionListField(adapter, buttons);
        this.fOptionalSubstitutionsField.setLabelText(PreferencesMessages.HeaderSubstitutionMapEditDialog_optional_substitution);
        this.fOptionalSubstitutionsField.setDialogFieldListener(adapter);
        this.fOptionalSubstitutionsField.enableButton(1, false);
        this.fOptionalSubstitutionsField.setTableColumns(new ListDialogField.ColumnsDescription(columnsHeaders, true));
        this.updateFromMap(map);
        adapter.selectionChanged(this.fUnconditionalSubstitutionsField);
        adapter.selectionChanged(this.fOptionalSubstitutionsField);
    }

    private void updateFromMap(HeaderSubstitutionMap map) {
        this.fNameField.setText(map != null ? map.getName() : this.createUniqueName());
        this.fAppliesToField.selectItem(map != null && map.isCppOnly() ? 1 : 0);
        if (map != null) {
            List<HeaderSubstitutionRule> substitutionRules = this.getSubstitutionRules(map.getUnconditionalSubstitutionMap());
            this.fUnconditionalSubstitutionsField.setElements(substitutionRules);
            substitutionRules = this.getSubstitutionRules(map.getOptionalSubstitutionMap());
            this.fOptionalSubstitutionsField.setElements(substitutionRules);
        }
    }

    private String createUniqueName() {
        int i = 1;
        String name;
        while (this.fExistingNames.contains(name = NLS.bind((String)PreferencesMessages.HeaderSubstitutionMapEditDialog_default_map_name, (Object)i))) {
            ++i;
        }
        return name;
    }

    private List<HeaderSubstitutionRule> getSubstitutionRules(IncludeMap map) {
        ArrayList<HeaderSubstitutionRule> result = new ArrayList<HeaderSubstitutionRule>();
        for (Map.Entry<IncludeInfo, List<IncludeInfo>> entry : map.getMap().entrySet()) {
            String source = this.stripQuotes(entry.getKey().toString());
            for (IncludeInfo target : entry.getValue()) {
                boolean unconditional = map.isUnconditionalSubstitution();
                HeaderSubstitutionRule rule = new HeaderSubstitutionRule(source, this.stripQuotes(target.toString()), unconditional);
                result.add(rule);
            }
        }
        Collections.sort(result, SOURCE_COMPARATOR);
        return result;
    }

    private String stripQuotes(String str) {
        if (str.length() > 2 && str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"') {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public HeaderSubstitutionMap getResult() {
        HeaderSubstitutionMap map = this.createEmptyMap();
        for (HeaderSubstitutionRule substitution : this.fUnconditionalSubstitutionsField.getElements()) {
            map.addMapping(substitution.getSource(), substitution.getTarget(), true);
        }
        for (HeaderSubstitutionRule substitution : this.fOptionalSubstitutionsField.getElements()) {
            map.addMapping(substitution.getSource(), substitution.getTarget(), false);
        }
        return map;
    }

    private HeaderSubstitutionMap createEmptyMap() {
        HeaderSubstitutionMap map = new HeaderSubstitutionMap(this.fAppliesToField.getSelectionIndex() != 0);
        map.setName(this.fNameField.getText().trim());
        return map;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        PixelConverter conv = new PixelConverter((Control)composite);
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 4;
        inner.setLayout((Layout)layout);
        this.fNameField.doFillIntoGrid(inner, 3);
        if (this.fNewMap) {
            this.fNameField.getTextControl(null).selectAll();
        }
        Button button = new Button(inner, 8);
        button.setText(PreferencesMessages.HeaderSubstitutionMapEditDialog_import_button);
        button.setLayoutData((Object)new GridData(4, 2, false, false));
        button.addSelectionListener((SelectionListener)new ButtonSelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HeaderSubstitutionMapEditDialog.this.importFromFile();
            }
        });
        this.fAppliesToField.doFillIntoGrid(inner, 3);
        button = new Button(inner, 8);
        button.setText(PreferencesMessages.HeaderSubstitutionMapEditDialog_export_button);
        button.setLayoutData((Object)new GridData(4, 2, false, false));
        button.addSelectionListener((SelectionListener)new ButtonSelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HeaderSubstitutionMapEditDialog.this.exportToFile();
            }
        });
        Separator separator = new Separator(0);
        separator.doFillIntoGrid(inner, 4, conv.convertHeightInCharsToPixels(1));
        int minHeight = this.convertHeightInCharsToPixels(12);
        this.fUnconditionalSubstitutionsField.doFillIntoGrid(inner, 4);
        LayoutUtil.setHeightHint(this.fUnconditionalSubstitutionsField.getListControl(null), minHeight);
        this.fOptionalSubstitutionsField.doFillIntoGrid(inner, 4);
        LayoutUtil.setHeightHint(this.fOptionalSubstitutionsField.getListControl(null), minHeight);
        HeaderSubstitutionMapEditDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void importFromFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(PreferencesMessages.HeaderSubstitutionMapEditDialog_import_title);
        dialog.setFilterExtensions(new String[]{"*.xml"});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        try {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(Path.fromOSString((String)path));
            InputStream stream = fileStore.openInputStream(0, null);
            InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(stream), UTF_8);
            try {
                HeaderSubstitutionMap map = HeaderSubstitutionMap.fromSerializedMemento(reader);
                this.updateFromMap(map);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            String title = PreferencesMessages.HeaderSubstitutionMapEditDialog_import_title;
            String message = e.getLocalizedMessage();
            message = message != null ? NLS.bind((String)PreferencesMessages.HeaderSubstitutionMapEditDialog_error_parse_message, (Object)message) : NLS.bind((String)PreferencesMessages.HeaderSubstitutionMapEditDialog_error_read_message, (Object)path);
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)PreferencesMessages.HeaderSubstitutionMapEditDialog_import_title, (String)e.getLocalizedMessage());
        }
        this.updateButtonState();
    }

    private void exportToFile() {
        HeaderSubstitutionMap map = this.getResult();
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(PreferencesMessages.HeaderSubstitutionMapEditDialog_export_title);
        dialog.setFilterExtensions(new String[]{"*.xml"});
        dialog.setFileName(String.valueOf(map.getName()) + ".xml");
        dialog.setOverwrite(true);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        try {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(Path.fromOSString((String)path));
            OutputStream stream = fileStore.openOutputStream(2, null);
            XMLMemento memento = XMLMemento.createWriteRoot((String)TAG_HEADER_SUBSTITUTION_MAP);
            map.saveToMemento((IMemento)memento);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(stream), UTF_8);
            try {
                memento.save((Writer)writer);
            }
            finally {
                try {
                    ((Writer)writer).close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)PreferencesMessages.HeaderSubstitutionMapEditDialog_export_title, (String)PreferencesMessages.HeaderSubstitutionMapEditDialog_error_write_message);
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)PreferencesMessages.HeaderSubstitutionMapEditDialog_export_title, (String)e.getLocalizedMessage());
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.cdt.ui.header_substitution_map_edit_dialog_context");
    }

    private void onButtonPressed(ListDialogField<HeaderSubstitutionRule> field, int buttonId) {
        HeaderSubstitutionRule oldRule = null;
        oldRule = buttonId == 0 ? new HeaderSubstitutionRule("", "", field == this.fUnconditionalSubstitutionsField) : field.getSelectedElements().get(0);
        switch (buttonId) {
            case 0: 
            case 1: {
                HeaderSubstitutionListField newField;
                HeaderSubstitutionEditDialog dialog = new HeaderSubstitutionEditDialog(this.getShell(), oldRule);
                if (dialog.open() != 0) break;
                HeaderSubstitutionRule newRule = dialog.getResult();
                HeaderSubstitutionListField headerSubstitutionListField = newField = newRule.isUnconditionalSubstitution() ? this.fUnconditionalSubstitutionsField : this.fOptionalSubstitutionsField;
                if (buttonId == 0) {
                    newField.addElement(newRule);
                } else if (newField == field) {
                    field.replaceElement(oldRule, newRule);
                } else {
                    field.removeElement(oldRule);
                    newField.addElement(newRule);
                }
                List elements = newField.getElements();
                Collections.sort(elements, SOURCE_COMPARATOR);
                newField.setElements(elements);
                for (HeaderSubstitutionRule rule : this.fUnconditionalSubstitutionsField.getElements()) {
                    if (rule == newRule || !rule.getSource().equals(newRule.getSource())) continue;
                    this.fUnconditionalSubstitutionsField.removeElement(rule);
                }
                if (!newRule.isUnconditionalSubstitution()) break;
                ArrayList<HeaderSubstitutionRule> rulesToDelete = null;
                for (HeaderSubstitutionRule rule : this.fOptionalSubstitutionsField.getElements()) {
                    if (!rule.getSource().equals(newRule.getSource())) continue;
                    if (rulesToDelete == null) {
                        rulesToDelete = new ArrayList<HeaderSubstitutionRule>();
                    }
                    rulesToDelete.add(rule);
                }
                if (rulesToDelete == null) break;
                this.fOptionalSubstitutionsField.removeElements(rulesToDelete);
            }
        }
        this.updateButtonState();
    }

    private void updateButtonState() {
        IStatus status = StatusInfo.OK_STATUS;
        String name = this.fNameField.getText().trim();
        if (name.isEmpty()) {
            status = new StatusInfo(2, PreferencesMessages.HeaderSubstitutionMapEditDialog_enter_name);
        } else if (this.fExistingNames.contains(name)) {
            status = new StatusInfo(2, PreferencesMessages.HeaderSubstitutionMapEditDialog_duplicate_name);
        } else if (this.fUnconditionalSubstitutionsField.getElements().isEmpty() && this.fOptionalSubstitutionsField.getElements().isEmpty()) {
            status = new StatusInfo(2, PreferencesMessages.HeaderSubstitutionMapEditDialog_map_is_empty);
        }
        this.updateStatus(status);
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState((IStatus)(status.isOK() ? status : new StatusInfo(4, null)));
    }

    private static abstract class ButtonSelectionListener
    implements SelectionListener {
        private ButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class HeaderSubstitutionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            HeaderSubstitutionRule substitution = (HeaderSubstitutionRule)element;
            return columnIndex == 0 ? substitution.getSource() : substitution.getTarget();
        }

        public Font getFont(Object element) {
            return null;
        }
    }

    private class HeaderSubstitutionListField
    extends ListDialogField<HeaderSubstitutionRule> {
        HeaderSubstitutionListField(IListAdapter<HeaderSubstitutionRule> adapter, String[] buttons) {
            super(adapter, buttons, (IBaseLabelProvider)new HeaderSubstitutionLabelProvider());
        }

        @Override
        protected boolean getManagedButtonState(ISelection sel, int index) {
            if (index == 2) {
                return !sel.isEmpty();
            }
            if (index == 3) {
                return !sel.isEmpty() && this.canMoveUp();
            }
            if (index == 4) {
                return !sel.isEmpty() && this.canMoveDown();
            }
            return true;
        }

        @Override
        protected boolean managedButtonPressed(int index) {
            if (index == 2) {
                this.remove();
            } else if (index == 3) {
                this.up();
            } else if (index == 4) {
                this.down();
            } else {
                return false;
            }
            return true;
        }

        @Override
        protected boolean canMoveUp() {
            if (!this.isOkToUse(this.fTableControl)) {
                return false;
            }
            int[] indc = this.fTable.getTable().getSelectionIndices();
            int i = 0;
            while (i < indc.length) {
                int index = indc[i];
                if (index == 0 || SOURCE_COMPARATOR.compare((HeaderSubstitutionRule)this.fElements.get(index), (HeaderSubstitutionRule)this.fElements.get(index - 1)) != 0) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        protected boolean canMoveDown() {
            if (!this.isOkToUse(this.fTableControl)) {
                return false;
            }
            int k = this.fElements.size() - 1;
            int[] indc = this.fTable.getTable().getSelectionIndices();
            int i = 0;
            while (i < indc.length) {
                int index = indc[i];
                if (index == k || SOURCE_COMPARATOR.compare((HeaderSubstitutionRule)this.fElements.get(index), (HeaderSubstitutionRule)this.fElements.get(index + 1)) != 0) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    public class ListAdapter
    implements IListAdapter<HeaderSubstitutionRule>,
    IDialogFieldListener {
        private boolean canEdit(List<HeaderSubstitutionRule> selectedElements) {
            return selectedElements.size() == 1;
        }

        @Override
        public void customButtonPressed(ListDialogField<HeaderSubstitutionRule> field, int index) {
            HeaderSubstitutionMapEditDialog.this.onButtonPressed(field, index);
        }

        @Override
        public void selectionChanged(ListDialogField<HeaderSubstitutionRule> field) {
            List<HeaderSubstitutionRule> selectedElements = field.getSelectedElements();
            field.enableButton(1, this.canEdit(selectedElements));
        }

        @Override
        public void doubleClicked(ListDialogField<HeaderSubstitutionRule> field) {
            if (this.canEdit(field.getSelectedElements())) {
                HeaderSubstitutionMapEditDialog.this.onButtonPressed(field, 1);
            }
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            HeaderSubstitutionMapEditDialog.this.updateButtonState();
        }
    }
}

