/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.language.settings.providers;

import java.net.URI;
import org.eclipse.cdt.core.EFSExtensionProvider;
import org.eclipse.cdt.internal.core.Cygwin;
import org.eclipse.cdt.managedbuilder.buildproperties.IOptionalBuildProperties;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.language.settings.providers.GCCBuiltinSpecsDetector;

public class GCCBuiltinSpecsDetectorCygwin
extends GCCBuiltinSpecsDetector {
    private static final String GCC_TOOLCHAIN_ID_CYGWIN = "cdt.managedbuild.toolchain.gnu.cygwin.base";
    private static final String ENV_PATH = "PATH";
    public static final String CONTAINER_ENABLEMENT_PROPERTY = "org.eclipse.cdt.docker.launcher.containerbuild.property.enablement";

    @Override
    public String getToolchainId() {
        return GCC_TOOLCHAIN_ID_CYGWIN;
    }

    @Override
    protected EFSExtensionProvider getEFSProvider() {
        String envPathValue = this.environmentMap != null ? (String)this.environmentMap.get(ENV_PATH) : null;
        return new CygwinEFSExtensionProvider(envPathValue);
    }

    @Override
    public GCCBuiltinSpecsDetectorCygwin cloneShallow() throws CloneNotSupportedException {
        return (GCCBuiltinSpecsDetectorCygwin)super.cloneShallow();
    }

    @Override
    public GCCBuiltinSpecsDetectorCygwin clone() throws CloneNotSupportedException {
        return (GCCBuiltinSpecsDetectorCygwin)super.clone();
    }

    private class CygwinEFSExtensionProvider
    extends EFSExtensionProvider {
        private String envPathValue;

        public CygwinEFSExtensionProvider(String envPathValue) {
            this.envPathValue = envPathValue;
        }

        public String getMappedPath(URI locationURI) {
            String windowsPath = null;
            try {
                IOptionalBuildProperties bp;
                String ep;
                String cygwinPath = this.getPathFromURI(locationURI);
                IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription(GCCBuiltinSpecsDetectorCygwin.this.currentCfgDescription);
                if (!(cfg == null || (ep = (bp = cfg.getOptionalBuildProperties()).getProperty(GCCBuiltinSpecsDetectorCygwin.CONTAINER_ENABLEMENT_PROPERTY)) != null && Boolean.parseBoolean(ep))) {
                    windowsPath = Cygwin.cygwinToWindowsPath((String)cygwinPath, (String)this.envPathValue);
                }
            }
            catch (Exception e) {
                ManagedBuilderCorePlugin.log(e);
            }
            if (windowsPath != null) {
                return windowsPath;
            }
            return super.getMappedPath(locationURI);
        }
    }
}

