/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.remote;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.launch.remote.Activator;
import org.eclipse.cdt.internal.launch.remote.Messages;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.remote.core.IRemoteCommandShellService;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionHostService;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.RemoteProcessAdapter;

public class RemoteHelper {
    private static final String EXIT_CMD = "exit";
    private static final String CMD_DELIMITER = ";";

    public static IRemoteConnection getRemoteConnectionByName(String remoteConnection) {
        if (remoteConnection == null) {
            return null;
        }
        IRemoteServicesManager manager = Activator.getService(IRemoteServicesManager.class);
        if (manager == null) {
            return null;
        }
        List conns = manager.getAllRemoteConnections();
        for (IRemoteConnection conn : conns) {
            if (!conn.getName().contentEquals(remoteConnection)) continue;
            return conn;
        }
        return null;
    }

    public static IRemoteFileService getFileSubsystem(IRemoteConnection conn) {
        if (conn == null) {
            return null;
        }
        return (IRemoteFileService)conn.getService(IRemoteFileService.class);
    }

    public static IRemoteConnection[] getSuitableConnections() {
        IRemoteServicesManager manager = Activator.getService(IRemoteServicesManager.class);
        if (manager == null) {
            return null;
        }
        ArrayList<IRemoteConnection> suitableConnections = new ArrayList<IRemoteConnection>();
        List allConnections = manager.getAllRemoteConnections();
        for (IRemoteConnection conn : allConnections) {
            if (!conn.hasService(IRemoteCommandShellService.class)) continue;
            suitableConnections.add(conn);
        }
        return suitableConnections.toArray(new IRemoteConnection[0]);
    }

    public static void remoteFileDownload(ILaunchConfiguration config, ILaunch launch, String localExePath, String remoteExePath, IProgressMonitor monitor) throws CoreException {
        boolean skipDownload = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_SKIP_DOWNLOAD_TO_TARGET, false);
        if (skipDownload) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RemoteRunLaunchDelegate_2, (int)100);
        try {
            IRemoteConnection conn = RemoteHelper.getCurrentConnection(config);
            IRemoteFileService fs = (IRemoteFileService)conn.getService(IRemoteFileService.class);
            IFileStore remoteFile = fs.getResource(remoteExePath);
            IFileSystem localfs = EFS.getLocalFileSystem();
            IFileStore localFile = localfs.getStore((IPath)new Path(localExePath));
            if (!localFile.fetchInfo().exists()) {
                return;
            }
            try {
                localFile.copy(remoteFile, 2, (IProgressMonitor)subMonitor.split(95));
                IFileInfo remoteFileInfo = remoteFile.fetchInfo();
                remoteFileInfo.setAttribute(0x1000000, true);
                remoteFileInfo.setAttribute(0x8000000, true);
                remoteFileInfo.setAttribute(0x40000000, true);
                remoteFile.putInfo(remoteFileInfo, 1024, (IProgressMonitor)subMonitor.split(5));
            }
            catch (CoreException e) {
                RemoteHelper.abort(Messages.RemoteRunLaunchDelegate_6, e, 150);
            }
        }
        finally {
            monitor.done();
        }
    }

    public static String spaceEscapify(String inputString) {
        if (inputString == null) {
            return null;
        }
        return inputString.replaceAll(" ", "\\\\ ");
    }

    public static IRemoteConnection getCurrentConnection(ILaunchConfiguration config) throws CoreException {
        String remoteConnection = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_CONNECTION, "");
        IRemoteConnection connection = RemoteHelper.getRemoteConnectionByName(remoteConnection);
        if (connection == null) {
            RemoteHelper.abort(Messages.RemoteRunLaunchDelegate_13, null, 150);
        }
        return connection;
    }

    public static Process remoteShellExec(ILaunchConfiguration config, String prelaunchCmd, String remoteCommandPath, String arguments, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(NLS.bind((String)Messages.RemoteRunLaunchDelegate_8, (Object)remoteCommandPath, (Object)arguments), 10);
        String realRemoteCommand = arguments == null ? RemoteHelper.spaceEscapify(remoteCommandPath) : String.valueOf(RemoteHelper.spaceEscapify(remoteCommandPath)) + " " + arguments;
        String remoteCommand = String.valueOf(realRemoteCommand) + CMD_DELIMITER + EXIT_CMD + "\r\n";
        if (!prelaunchCmd.trim().equals("")) {
            remoteCommand = String.valueOf(prelaunchCmd) + CMD_DELIMITER + remoteCommand;
        }
        IRemoteConnection conn = RemoteHelper.getCurrentConnection(config);
        IRemoteCommandShellService shellService = (IRemoteCommandShellService)conn.getService(IRemoteCommandShellService.class);
        IRemoteProcess remoteProcess = null;
        RemoteProcessAdapter p = null;
        try {
            remoteProcess = shellService.getCommandShell(1);
            p = new RemoteProcessAdapter(remoteProcess);
            OutputStream os = remoteProcess.getOutputStream();
            os.write(remoteCommand.getBytes());
            os.flush();
        }
        catch (IOException e) {
            RemoteHelper.abort(Messages.RemoteRunLaunchDelegate_7, e, 150);
        }
        monitor.done();
        return p;
    }

    public static IRemoteProcess execCmdInRemoteShell(ILaunchConfiguration config, String prelaunchCmd, String remoteCommandPath, String arguments, IProgressMonitor monitor) throws Exception {
        IRemoteConnection conn;
        monitor.beginTask(NLS.bind((String)Messages.RemoteRunLaunchDelegate_8, (Object)remoteCommandPath, (Object)arguments), 10);
        String realRemoteCommand = arguments == null ? RemoteHelper.spaceEscapify(remoteCommandPath) : String.valueOf(RemoteHelper.spaceEscapify(remoteCommandPath)) + " " + arguments;
        String remoteCommand = String.valueOf(realRemoteCommand) + CMD_DELIMITER + EXIT_CMD + "\r\n";
        if (!prelaunchCmd.trim().equals("")) {
            remoteCommand = String.valueOf(prelaunchCmd) + CMD_DELIMITER + remoteCommand;
        }
        if (!(conn = RemoteHelper.getCurrentConnection(config)).isOpen()) {
            conn.open(monitor);
        }
        IRemoteCommandShellService shellService = (IRemoteCommandShellService)conn.getService(IRemoteCommandShellService.class);
        IRemoteProcess p = null;
        p = shellService.getCommandShell(1);
        OutputStream os = p.getOutputStream();
        os.write(remoteCommand.getBytes());
        os.flush();
        monitor.done();
        return p;
    }

    public static String getRemoteHostname(ILaunchConfiguration config) throws CoreException {
        IRemoteConnection currentConnection = RemoteHelper.getCurrentConnection(config);
        IRemoteConnectionHostService hostService = (IRemoteConnectionHostService)currentConnection.getService(IRemoteConnectionHostService.class);
        return hostService.getHostname();
    }

    public static void abort(String message, Throwable exception, int code) throws CoreException {
        Status status;
        if (exception != null) {
            MultiStatus multiStatus = new MultiStatus("org.eclipse.cdt.launch.remote", code, message, exception);
            multiStatus.add((IStatus)new Status(4, "org.eclipse.cdt.launch.remote", code, exception.getLocalizedMessage(), exception));
            status = multiStatus;
        } else {
            status = new Status(4, "org.eclipse.cdt.launch.remote", code, message, null);
        }
        throw new CoreException((IStatus)status);
    }
}

