/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.viewmodel.actions;

import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.core.model.IViewInMemory;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.VariableVMNode;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DsfViewMemoryHandler
extends AbstractHandler {
    private VariableVMNode.VariableExpressionVMC[] fMemoryViewables = new VariableVMNode.VariableExpressionVMC[0];

    protected VariableVMNode.VariableExpressionVMC[] getMemoryViewables() {
        return this.fMemoryViewables;
    }

    protected void setMemoryViewables(VariableVMNode.VariableExpressionVMC[] viewableMemoryITems) {
        this.fMemoryViewables = viewableMemoryITems;
    }

    public void setEnabled(Object evaluationContext) {
        VariableVMNode.VariableExpressionVMC[] viewableMemoryITems = this.getMemoryViewables(evaluationContext);
        this.setBaseEnabled(viewableMemoryITems.length > 0);
        this.setMemoryViewables(viewableMemoryITems);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.getMemoryViewables() == null || this.getMemoryViewables().length == 0) {
            return null;
        }
        this.showInMemoryView(this.getMemoryViewables());
        return null;
    }

    private VariableVMNode.VariableExpressionVMC[] getMemoryViewables(Object evaluationContext) {
        Object s;
        ArrayList<VariableVMNode.VariableExpressionVMC> viewableMemoryItems = new ArrayList<VariableVMNode.VariableExpressionVMC>();
        if (evaluationContext instanceof IEvaluationContext && (s = ((IEvaluationContext)evaluationContext).getVariable("activeMenuSelection")) instanceof IStructuredSelection) {
            for (Object obj : (IStructuredSelection)s) {
                Object element;
                if (!(obj instanceof VariableVMNode.VariableExpressionVMC) || (element = DebugPlugin.getAdapter(obj, IViewInMemory.class)) == null || !((IViewInMemory)element).canViewInMemory()) continue;
                viewableMemoryItems.add((VariableVMNode.VariableExpressionVMC)obj);
            }
        }
        return viewableMemoryItems.toArray(new VariableVMNode.VariableExpressionVMC[viewableMemoryItems.size()]);
    }

    private void addDefaultRenderings(IMemoryBlock memoryBlock, IMemoryRenderingSite memRendSite) {
        IMemoryRenderingType primaryType = DebugUITools.getMemoryRenderingManager().getPrimaryRenderingType(memoryBlock);
        IMemoryRenderingType[] renderingTypes = DebugUITools.getMemoryRenderingManager().getDefaultRenderingTypes(memoryBlock);
        try {
            if (primaryType != null) {
                this.createRenderingInContainer(memoryBlock, memRendSite, primaryType, "org.eclipse.debug.ui.MemoryView.RenderingViewPane.1");
            } else if (renderingTypes.length > 0) {
                primaryType = renderingTypes[0];
                this.createRenderingInContainer(memoryBlock, memRendSite, renderingTypes[0], "org.eclipse.debug.ui.MemoryView.RenderingViewPane.1");
            }
        }
        catch (CoreException e) {
            DsfUIPlugin.logErrorMessage(e.getMessage());
        }
        int i = 0;
        while (i < renderingTypes.length) {
            try {
                boolean create = true;
                if (primaryType != null && primaryType.getId().equals(renderingTypes[i].getId())) {
                    create = false;
                }
                if (create) {
                    this.createRenderingInContainer(memoryBlock, memRendSite, renderingTypes[i], "org.eclipse.debug.ui.MemoryView.RenderingViewPane.2");
                }
            }
            catch (CoreException e) {
                DsfUIPlugin.logErrorMessage(e.getMessage());
            }
            ++i;
        }
    }

    private void createRenderingInContainer(IMemoryBlock memoryBlock, IMemoryRenderingSite memRendSite, IMemoryRenderingType primaryType, String paneId) throws CoreException {
        IMemoryRendering rendering = primaryType.createRendering();
        IMemoryRenderingContainer container = memRendSite.getContainer(paneId);
        rendering.init(container, memoryBlock);
        container.addMemoryRendering(rendering);
    }

    private void renderMemoryBlock(IMemoryBlockExtension memBlock, IMemoryRenderingSite memRendSite) {
        IMemoryBlock[] memArray = new IMemoryBlock[]{memBlock};
        DebugPlugin.getDefault().getMemoryBlockManager().addMemoryBlocks(memArray);
        this.addDefaultRenderings((IMemoryBlock)memBlock, memRendSite);
    }

    private IStatus showExpressionInMemoryView(VariableVMNode.VariableExpressionVMC context, IExpressions.IExpressionDMData exprData, IMemoryRenderingSite memRendSite) {
        IExpressions.IExpressionDMData.BasicType type = exprData.getBasicType();
        String exprString = type == IExpressions.IExpressionDMData.BasicType.array || type == IExpressions.IExpressionDMData.BasicType.pointer ? context.getExpression() : "&(" + context.getExpression() + ")";
        try {
            IDMContext dmc = context.getDMContext();
            IMemoryBlockRetrieval retrieval = (IMemoryBlockRetrieval)context.getAdapter(IMemoryBlockRetrieval.class);
            if (retrieval == null && context instanceof IDebugElement) {
                retrieval = ((IDebugElement)context).getDebugTarget();
            }
            if (retrieval == null || !(retrieval instanceof IMemoryBlockRetrievalExtension)) {
                return Status.OK_STATUS;
            }
            IMemoryBlockRetrievalExtension dsfRetrieval = (IMemoryBlockRetrievalExtension)retrieval;
            IMemoryBlockExtension memBlock = dsfRetrieval.getExtendedMemoryBlock(exprString, (Object)dmc);
            this.renderMemoryBlock(memBlock, memRendSite);
            return Status.OK_STATUS;
        }
        catch (DebugException e) {
            return DsfUIPlugin.newErrorStatus(0, "Can't view memory on " + exprString, e);
        }
    }

    private void showInMemoryView(VariableVMNode.VariableExpressionVMC[] contexts) {
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewPart memoryView = page.showView("org.eclipse.debug.ui.MemoryView", null, 1);
            final IMemoryRenderingSite memRendSite = (IMemoryRenderingSite)memoryView;
            VariableVMNode.VariableExpressionVMC[] variableExpressionVMCArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                DsfExecutor executor;
                DsfSession session;
                final VariableVMNode.VariableExpressionVMC context = variableExpressionVMCArray[n2];
                final IExpressions.IExpressionDMContext dmc = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType((IDMContext)context.getDMContext(), IExpressions.IExpressionDMContext.class);
                if (dmc != null && (session = DsfSession.getSession((String)context.getDMContext().getSessionId())) != null && (executor = session.getExecutor()) != null) {
                    executor.execute((Runnable)new DsfRunnable(){

                        public void run() {
                            DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), session.getId());
                            IExpressions service = (IExpressions)tracker.getService(IExpressions.class);
                            tracker.dispose();
                            if (service != null) {
                                service.getExpressionData(dmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMData>((Executor)executor, null){

                                    protected void handleSuccess() {
                                        final IExpressions.IExpressionDMData exprData = (IExpressions.IExpressionDMData)this.getData();
                                        if (exprData != null) {
                                            Job job = new Job("View Memory"){

                                                protected IStatus run(IProgressMonitor monitor) {
                                                    return DsfViewMemoryHandler.this.showExpressionInMemoryView(context, exprData, memRendSite);
                                                }
                                            };
                                            job.setSystem(true);
                                            job.schedule();
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
                ++n2;
            }
        }
        catch (PartInitException e) {
            DsfUIPlugin.log(e);
        }
        catch (RejectedExecutionException e) {
            DsfUIPlugin.log(e);
        }
    }
}

