/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.cdt.docker.launcher.DockerLaunchUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class SWTImagesFactory {
    private static ImageRegistry imageRegistry = DockerLaunchUIPlugin.getDefault().getImageRegistry();
    private static URL fgIconBaseURL;
    private static final String NAME_PREFIX = "org.eclipse.cdt.docker.launcher.";
    private static final int NAME_PREFIX_LENGTH;
    public static final String IMG_CONTAINER = "org.eclipse.cdt.docker.launcher.repository-middle.gif";
    public static final String IMG_FOLDER_CLOSED = "org.eclipse.cdt.docker.launcher.folder_closed.gif";
    public static final String IMG_FILE = "org.eclipse.cdt.docker.launcher.file_obj.gif";
    public static final String IMG_WARNING = "org.eclipse.cdt.docker.launcher.warning_obj.gif";
    public static final String IMG_ERROR = "org.eclipse.cdt.docker.launcher.error_obj.gif";
    public static final ImageDescriptor DESC_CONTAINER;
    public static final ImageDescriptor DESC_FOLDER_CLOSED;
    public static final ImageDescriptor DESC_FILE;
    public static final ImageDescriptor DESC_WARNING;
    public static final ImageDescriptor DESC_ERROR;

    static {
        try {
            fgIconBaseURL = new URL(DockerLaunchUIPlugin.getDefault().getBundle().getEntry("/"), "icons/");
        }
        catch (MalformedURLException e) {
            DockerLaunchUIPlugin.log(e);
        }
        NAME_PREFIX_LENGTH = NAME_PREFIX.length();
        DESC_CONTAINER = SWTImagesFactory.createManaged("", IMG_CONTAINER);
        DESC_FOLDER_CLOSED = SWTImagesFactory.createManaged("", IMG_FOLDER_CLOSED);
        DESC_FILE = SWTImagesFactory.createManaged("", IMG_FILE);
        DESC_WARNING = SWTImagesFactory.createManaged("", IMG_WARNING);
        DESC_ERROR = SWTImagesFactory.createManaged("", IMG_ERROR);
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        return SWTImagesFactory.createManaged(imageRegistry, prefix, name);
    }

    private static ImageDescriptor createManaged(ImageRegistry registry, String prefix, String name) {
        ImageDescriptor result = ImageDescriptor.createFromURL((URL)SWTImagesFactory.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
        registry.put(name, result);
        return result;
    }

    public static Image get(String key) {
        return imageRegistry.get(key);
    }

    private static ImageDescriptor create(String prefix, String name) {
        return ImageDescriptor.createFromURL((URL)SWTImagesFactory.makeIconFileURL(prefix, name));
    }

    private static URL makeIconFileURL(String prefix, String name) {
        StringBuilder buffer = new StringBuilder(prefix);
        buffer.append(name);
        try {
            return new URL(fgIconBaseURL, buffer.toString());
        }
        catch (MalformedURLException e) {
            DockerLaunchUIPlugin.log(e);
            return null;
        }
    }

    public static void setImageDescriptors(IAction action, String type, String relPath) {
        if (relPath.startsWith(NAME_PREFIX)) {
            relPath = relPath.substring(NAME_PREFIX_LENGTH);
        }
        action.setDisabledImageDescriptor(SWTImagesFactory.create("d" + type, relPath));
        action.setImageDescriptor(SWTImagesFactory.create("e" + type, relPath));
    }

    static ImageRegistry getImageRegistry() {
        return imageRegistry;
    }
}

