/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.is.core.internal.builtins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.cdt.cmake.is.core.participant.IRawIndexerInfo;
import org.eclipse.cdt.cmake.is.core.participant.IRawIndexerInfoCollector;
import org.eclipse.core.runtime.Platform;

public class RawIndexerInfo
implements IRawIndexerInfo,
IRawIndexerInfoCollector {
    private static final boolean DEBUG = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.cmake.is.core/debug/detected.entries"));
    private final Map<String, String> defines = new HashMap<String, String>();
    private final List<String> undefines = new ArrayList<String>();
    private final List<String> includePaths = new ArrayList<String>();
    private final List<String> systemIncludePaths = new ArrayList<String>();
    private final List<String> macroFiles = new ArrayList<String>(0);
    private final List<String> includeFiles = new ArrayList<String>(0);

    @Override
    public void addDefine(String name, String value) {
        Objects.requireNonNull(name);
        value = Objects.toString(value, "");
        if (DEBUG) {
            System.out.printf("    Added define: %s=%s%n", name, value);
        }
        this.defines.put(name, value);
    }

    @Override
    public void addUndefine(String name) {
        Objects.requireNonNull(name);
        if (DEBUG) {
            System.out.printf("    Added undefine: %s%n", name);
        }
        this.undefines.add(name);
        Iterator<Map.Entry<String, String>> iter = this.defines.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> define = iter.next();
            if (!define.getKey().equals(name)) continue;
            if (DEBUG) {
                System.out.printf("      Removed define: %s=%s%n", define.getKey(), define.getValue());
            }
            iter.remove();
        }
    }

    @Override
    public void addIncludePath(String path) {
        Objects.requireNonNull(path);
        if (DEBUG) {
            System.out.printf("    Added incl path: %s%n", path);
        }
        this.includePaths.add(path);
    }

    @Override
    public void addSystemIncludePath(String path) {
        Objects.requireNonNull(path);
        if (DEBUG) {
            System.out.printf("    Added sys incl path: %s%n", path);
        }
        this.systemIncludePaths.add(path);
    }

    @Override
    public void addMacroFile(String path) {
        Objects.requireNonNull(path);
        if (DEBUG) {
            System.out.printf("    Added macro file: %s%n", path);
        }
        this.macroFiles.add(path);
    }

    @Override
    public void addIncludeFile(String path) {
        Objects.requireNonNull(path);
        if (DEBUG) {
            System.out.printf("    Added include file: %s%n", path);
        }
        this.includeFiles.add(path);
    }

    @Override
    public Map<String, String> getDefines() {
        return Collections.unmodifiableMap(this.defines);
    }

    @Override
    public List<String> getUndefines() {
        return Collections.unmodifiableList(this.undefines);
    }

    @Override
    public List<String> getIncludePaths() {
        return Collections.unmodifiableList(this.includePaths);
    }

    @Override
    public List<String> getSystemIncludePaths() {
        return Collections.unmodifiableList(this.systemIncludePaths);
    }

    @Override
    public List<String> getMacroFiles() {
        return Collections.unmodifiableList(this.macroFiles);
    }

    @Override
    public List<String> getIncludeFiles() {
        return Collections.unmodifiableList(this.includeFiles);
    }
}

