/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Extension;
import org.eclipse.bpmn2.Import;
import org.eclipse.bpmn2.util.Bpmn2OppositeReferenceAdapter;
import org.eclipse.bpmn2.util.Bpmn2Resource;
import org.eclipse.bpmn2.util.ImportHelper;
import org.eclipse.bpmn2.util.NamespaceHelper;
import org.eclipse.bpmn2.util.QNameURIHandler;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.SAXXMLHandler;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLLoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;
import org.xml.sax.helpers.DefaultHandler;

public class Bpmn2ResourceImpl
extends XMLResourceImpl
implements Bpmn2Resource {
    private QNameURIHandler uriHandler;
    private BpmnXmlHelper xmlHelper;
    protected Bpmn2OppositeReferenceAdapter oppositeReferenceAdapter = new Bpmn2OppositeReferenceAdapter();

    public Bpmn2OppositeReferenceAdapter getOppositeReferenceAdapter() {
        return this.oppositeReferenceAdapter;
    }

    public Bpmn2ResourceImpl(URI uri) {
        super(uri);
        this.xmlHelper = new BpmnXmlHelper(this);
        this.uriHandler = new QNameURIHandler(this.xmlHelper);
        this.getDefaultLoadOptions().put("URI_HANDLER", this.uriHandler);
        this.getDefaultSaveOptions().put("URI_HANDLER", this.uriHandler);
        this.eAdapters().add((Object)this.oppositeReferenceAdapter);
    }

    public NotificationChain basicSetResourceSet(ResourceSet resourceSet, NotificationChain notifications) {
        if (resourceSet != null) {
            resourceSet.eAdapters().add((Object)this.oppositeReferenceAdapter);
        }
        return super.basicSetResourceSet(resourceSet, notifications);
    }

    protected XMLSave createXMLSave() {
        this.prepareSave();
        return new XMLSaveImpl(this.createXMLHelper()){

            protected boolean shouldSaveFeature(EObject o, EStructuralFeature f) {
                if (Bpmn2Package.eINSTANCE.getDocumentation_Text().equals(f)) {
                    return false;
                }
                if (Bpmn2Package.eINSTANCE.getFormalExpression_Body().equals(f)) {
                    return false;
                }
                return super.shouldSaveFeature(o, f);
            }
        };
    }

    protected void prepareSave() {
        Definitions thisDefinitions = ImportHelper.getDefinitions(this);
        TreeIterator iter = this.getAllContents();
        while (iter.hasNext()) {
            EObject cur = (EObject)iter.next();
            Bpmn2ResourceImpl.setIdIfNotSet(cur);
            for (EObject referenced : cur.eCrossReferences()) {
                Resource refResource;
                Bpmn2ResourceImpl.setIdIfNotSet(referenced);
                if (thisDefinitions == null || (refResource = referenced.eResource()) == null || refResource == this) continue;
                this.createImportIfNecessary(thisDefinitions, refResource);
            }
        }
    }

    protected static void setIdIfNotSet(EObject obj) {
        EAttribute idAttr;
        if (obj.eClass() != null && (idAttr = obj.eClass().getEIDAttribute()) != null && !obj.eIsSet((EStructuralFeature)idAttr)) {
            obj.eSet((EStructuralFeature)idAttr, (Object)EcoreUtil.generateUUID());
        }
    }

    protected void createImportIfNecessary(Definitions definitions, Resource referenced) {
        if (ImportHelper.findImportForLocation(definitions, referenced.getURI()) == null) {
            URI referencingURI = ImportHelper.makeURICanonical(definitions.eResource().getURI());
            URI referencedURI = ImportHelper.makeURICanonical(referenced.getURI());
            Definitions importedDef = ImportHelper.getDefinitions(referenced);
            if (importedDef != null && importedDef.getTargetNamespace() != null) {
                Import newImport = Bpmn2Factory.eINSTANCE.createImport();
                newImport.setImportType(NamespaceHelper.xmiToXsdNamespaceUri("http://www.omg.org/spec/BPMN/20100524/MODEL-XMI"));
                newImport.setNamespace(importedDef.getTargetNamespace());
                newImport.setLocation(referencedURI.deresolve(referencingURI).toString());
                definitions.getImports().add(newImport);
            }
        }
    }

    protected XMLLoad createXMLLoad() {
        return new XMLLoadImpl(this.createXMLHelper()){

            protected DefaultHandler makeDefaultHandler() {
                return new BpmnXmlHandler(this.resource, this.helper, this.options);
            }
        };
    }

    protected XMLHelper createXMLHelper() {
        return this.xmlHelper;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class BpmnXmlHandler
    extends SAXXMLHandler {
        public BpmnXmlHandler(XMLResource xmiResource, XMLHelper helper, Map<?, ?> options) {
            super(xmiResource, helper, options);
        }

        protected void setValueFromId(EObject object, EReference eReference, String ids) {
            super.setValueFromId(object, eReference, eReference.isResolveProxies() ? ((QNameURIHandler)this.uriHandler).convertQNameToUri(ids) : ids);
        }

        private EObject loadExtensionSchema(QName xsdQname) {
            EPackage extensionPackage = this.extendedMetaData.getPackage(xsdQname.getNamespaceURI());
            if (extensionPackage == null) {
                try {
                    Class theXSDEcoreBuilderClass = CommonPlugin.loadClass((String)"org.eclipse.xsd", (String)"org.eclipse.xsd.ecore.XSDEcoreBuilder");
                    Constructor theXSDEcoreBuilderConstructor = theXSDEcoreBuilderClass.getConstructor(ExtendedMetaData.class, Map.class);
                    Field theOptionField = theXSDEcoreBuilderClass.getField("OPTION_REUSE_REGISTERED_PACKAGES");
                    Object theXsdOption = theOptionField.get(null);
                    URI location = (URI)this.urisToLocations.get(xsdQname.getNamespaceURI());
                    HashMap<Object, Boolean> options = new HashMap<Object, Boolean>();
                    options.put(theXsdOption, Boolean.TRUE);
                    XSDEcoreBuilder builder = (XSDEcoreBuilder)theXSDEcoreBuilderConstructor.newInstance(this.extendedMetaData, options);
                    builder.generate(location);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.extendedMetaData.getElement(xsdQname.getNamespaceURI(), xsdQname.getLocalPart());
        }

        public void endElement(String uri, String localName, String name) {
            Extension extension;
            EObject peekObject = (EObject)this.objects.peek();
            if (peekObject instanceof Extension && (extension = (Extension)peekObject).isMustUnderstand() && extension.getXsdDefinition() != null) {
                this.loadExtensionSchema(extension.getXsdDefinition());
            }
            super.endElement(uri, localName, name);
        }
    }

    protected static class BpmnXmlHelper
    extends XMLHelperImpl {
        public BpmnXmlHelper(Bpmn2ResourceImpl resource) {
            super((XMLResource)resource);
        }

        private Definitions getDefinitions() {
            return ImportHelper.getDefinitions((Resource)this.getResource());
        }

        public boolean isTargetNamespace(String prefix) {
            String prefixNs;
            if (prefix == null) {
                prefix = "";
            }
            if ((prefixNs = this.getNamespaceURI(prefix)) == null) {
                if ("".equals(prefix)) {
                    return true;
                }
                throw new IllegalArgumentException(String.format("The prefix '%s' is not valid.", prefix));
            }
            if (prefixNs.equals(this.getDefinitions().getTargetNamespace())) {
                return true;
            }
            return "".equals(prefix) && ImportHelper.findImportForNamespace(this.getDefinitions(), prefixNs) == null;
        }

        public URI getPathForPrefix(String prefix) {
            String ns = this.getNamespaceURI(prefix == null ? "" : prefix);
            if (ns != null) {
                Import imp = ImportHelper.findImportForNamespace(this.getDefinitions(), ns);
                if (imp != null) {
                    return URI.createURI((String)imp.getLocation()).resolve(ImportHelper.makeURICanonical(this.getResource().getURI()));
                }
                return URI.createURI((String)ns);
            }
            return URI.createURI((String)"");
        }

        private String getPrefixDuringSave(String namespace) {
            if (this.urisToPrefixes.containsKey(namespace)) {
                return (String)((List)this.urisToPrefixes.get(namespace)).get(0);
            }
            EPackage ePackage = this.extendedMetaData.getPackage(namespace);
            if (ePackage == null) {
                ePackage = this.extendedMetaData.demandPackage(namespace);
            }
            String prefix = namespace.equals(this.getDefinitions().getTargetNamespace()) ? "" : ePackage.getNsPrefix();
            String originalPrefix = String.valueOf(prefix) + "_";
            int discr = 0;
            while (this.prefixesToURIs.containsKey((Object)prefix) && !((String)this.prefixesToURIs.get((Object)prefix)).equals(namespace)) {
                prefix = String.valueOf(originalPrefix) + discr++;
            }
            if (!this.packages.containsKey(ePackage)) {
                this.packages.put(ePackage, prefix);
            }
            this.prefixesToURIs.put((Object)prefix, (Object)namespace);
            return prefix;
        }

        public String getNsPrefix(URI referenced) {
            URI thisAbs;
            String ns = null;
            String prefix = "";
            URI referencedAbs = ImportHelper.makeURICanonical(referenced);
            URI relativeToThis = referencedAbs.deresolve(thisAbs = ImportHelper.makeURICanonical(this.getResource().getURI()));
            if (relativeToThis.isEmpty()) {
                ns = this.getDefinitions().getTargetNamespace();
            } else {
                Import impForRef = ImportHelper.findImportForLocation(this.getDefinitions(), referenced);
                if (impForRef != null) {
                    ns = impForRef.getNamespace();
                }
            }
            if (ns != null) {
                prefix = this.getPrefixDuringSave(ns);
            }
            return prefix;
        }
    }
}

