/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.gateway;

import org.eclipse.bpmn2.modeler.core.features.BaseElementFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.MoveFlowNodeFeature;
import org.eclipse.bpmn2.modeler.core.features.label.UpdateLabelFeature;
import org.eclipse.bpmn2.modeler.ui.features.AbstractDefaultDeleteFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.AppendActivityFeature;
import org.eclipse.bpmn2.modeler.ui.features.event.AppendEventFeature;
import org.eclipse.bpmn2.modeler.ui.features.gateway.AppendGatewayFeature;
import org.eclipse.bpmn2.modeler.ui.features.gateway.MorphGatewayFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public abstract class AbstractGatewayFeatureContainer
extends BaseElementFeatureContainer {
    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        return new UpdateAbstractGatewayFeature(fp);
    }

    public ILayoutFeature getLayoutFeature(IFeatureProvider fp) {
        return null;
    }

    public IMoveShapeFeature getMoveFeature(IFeatureProvider fp) {
        return new MoveFlowNodeFeature(fp);
    }

    public IResizeShapeFeature getResizeFeature(IFeatureProvider fp) {
        return new DefaultResizeShapeFeature(fp){

            public boolean canResizeShape(IResizeShapeContext context) {
                return false;
            }
        };
    }

    public IDeleteFeature getDeleteFeature(IFeatureProvider fp) {
        return new AbstractDefaultDeleteFeature(fp);
    }

    public ICustomFeature[] getCustomFeatures(IFeatureProvider fp) {
        ICustomFeature[] superFeatures = super.getCustomFeatures(fp);
        ICustomFeature[] thisFeatures = new ICustomFeature[4 + superFeatures.length];
        int i = 0;
        while (i < superFeatures.length) {
            thisFeatures[i] = superFeatures[i];
            ++i;
        }
        thisFeatures[i++] = new AppendActivityFeature(fp);
        thisFeatures[i++] = new AppendGatewayFeature(fp);
        thisFeatures[i++] = new AppendEventFeature(fp);
        thisFeatures[i++] = new MorphGatewayFeature(fp);
        return thisFeatures;
    }

    private class UpdateAbstractGatewayFeature
    extends UpdateLabelFeature {
        public UpdateAbstractGatewayFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canUpdate(IUpdateContext context) {
            IFeatureProvider featureProvider = this.getFeatureProvider();
            if (context.getPictogramElement() instanceof ContainerShape) {
                ContainerShape gatewayShape = (ContainerShape)context.getPictogramElement();
                for (Anchor anchor : gatewayShape.getAnchors()) {
                    boolean ret;
                    IUpdateFeature updateFeature;
                    UpdateContext updateCtx;
                    for (Connection connection : anchor.getIncomingConnections()) {
                        updateCtx = new UpdateContext((PictogramElement)connection);
                        updateFeature = featureProvider.getUpdateFeature((IUpdateContext)updateCtx);
                        if (updateFeature == null || !(ret = updateFeature.canUpdate((IUpdateContext)updateCtx))) continue;
                        return ret;
                    }
                    for (Connection connection : anchor.getOutgoingConnections()) {
                        updateCtx = new UpdateContext((PictogramElement)connection);
                        updateFeature = featureProvider.getUpdateFeature((IUpdateContext)updateCtx);
                        if (updateFeature == null || !(ret = updateFeature.canUpdate((IUpdateContext)updateCtx))) continue;
                        return ret;
                    }
                }
            }
            return super.canUpdate(context);
        }

        public IReason updateNeeded(IUpdateContext context) {
            IReason reason = super.updateNeeded(context);
            if (reason.toBoolean()) {
                return reason;
            }
            IFeatureProvider featureProvider = this.getFeatureProvider();
            if (context.getPictogramElement() instanceof ContainerShape) {
                ContainerShape gatewayShape = (ContainerShape)context.getPictogramElement();
                for (Anchor anchor : gatewayShape.getAnchors()) {
                    IReason ret;
                    IUpdateFeature updateFeature;
                    UpdateContext updateCtx;
                    for (Connection connection : anchor.getIncomingConnections()) {
                        updateCtx = new UpdateContext((PictogramElement)connection);
                        updateFeature = featureProvider.getUpdateFeature((IUpdateContext)updateCtx);
                        if (updateFeature == null || !(ret = updateFeature.updateNeeded((IUpdateContext)updateCtx)).toBoolean()) continue;
                        return ret;
                    }
                    for (Connection connection : anchor.getOutgoingConnections()) {
                        updateCtx = new UpdateContext((PictogramElement)connection);
                        updateFeature = featureProvider.getUpdateFeature((IUpdateContext)updateCtx);
                        if (updateFeature == null || !(ret = updateFeature.updateNeeded((IUpdateContext)updateCtx)).toBoolean()) continue;
                        return ret;
                    }
                }
            }
            return super.updateNeeded(context);
        }

        public boolean update(IUpdateContext context) {
            IFeatureProvider featureProvider = this.getFeatureProvider();
            if (context.getPictogramElement() instanceof ContainerShape) {
                ContainerShape gatewayShape = (ContainerShape)context.getPictogramElement();
                for (Anchor anchor : gatewayShape.getAnchors()) {
                    IUpdateFeature updateFeature;
                    UpdateContext updateCtx;
                    for (Connection connection : anchor.getIncomingConnections()) {
                        updateCtx = new UpdateContext((PictogramElement)connection);
                        updateFeature = featureProvider.getUpdateFeature((IUpdateContext)updateCtx);
                        if (updateFeature == null) continue;
                        updateFeature.update((IUpdateContext)updateCtx);
                    }
                    for (Connection connection : anchor.getOutgoingConnections()) {
                        updateCtx = new UpdateContext((PictogramElement)connection);
                        updateFeature = featureProvider.getUpdateFeature((IUpdateContext)updateCtx);
                        if (updateFeature == null) continue;
                        updateFeature.update((IUpdateContext)updateCtx);
                    }
                }
            }
            return super.update(context);
        }
    }
}

