/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.helpers;

import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.xml.sax.SAXException;

public class LocationCapturingDOMParser
extends DOMParser {
    protected XMLLocator mLocator;
    protected int fLineNo = 0;
    protected int fColumnNo = 0;
    protected int fOffset = 0;

    public LocationCapturingDOMParser() {
        try {
            this.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            this.setFeature("http://apache.org/xml/features/xinclude", false);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    void lastSource() {
        this.fLineNo = this.mLocator.getLineNumber();
        this.fColumnNo = this.mLocator.getColumnNumber();
        this.fOffset = this.mLocator.getCharacterOffset();
    }

    public void startDocument(XMLLocator arg0, String arg1, NamespaceContext arg2, Augmentations arg3) throws XNIException {
        this.mLocator = arg0;
        super.startDocument(arg0, arg1, arg2, arg3);
        this.lastSource();
    }

    public void characters(XMLString arg0, Augmentations arg1) throws XNIException {
        super.characters(arg0, arg1);
        this.lastSource();
    }

    public void comment(XMLString arg0, Augmentations arg1) throws XNIException {
        super.comment(arg0, arg1);
        this.lastSource();
    }

    public void textDecl(String arg0, String arg1, Augmentations arg2) throws XNIException {
        super.textDecl(arg0, arg1, arg2);
        this.lastSource();
    }

    public void startElement(QName arg0, XMLAttributes arg1, Augmentations arg2) throws XNIException {
        super.startElement(arg0, arg1, arg2);
        if (this.fCurrentNode != null) {
            this.fCurrentNode.setUserData("location.line", this.fLineNo, null);
            this.fCurrentNode.setUserData("location.column", this.fColumnNo, null);
            this.fCurrentNode.setUserData("location.charStart", this.fOffset + 1, null);
            this.fCurrentNode.setUserData("location.charEnd", this.fOffset + arg0.rawname.length() + 1, null);
            this.fCurrentNode.setUserData("location2.line", this.mLocator.getLineNumber(), null);
            this.fCurrentNode.setUserData("location2.column", this.mLocator.getColumnNumber(), null);
            this.fCurrentNode.setUserData("location2.charStart", this.mLocator.getCharacterOffset(), null);
            this.fCurrentNode.setUserData("location2.charEnd", this.mLocator.getCharacterOffset(), null);
        }
        this.lastSource();
    }

    public void startCDATA(Augmentations aug) {
        super.startCDATA(aug);
        this.lastSource();
    }

    public void endCDATA(Augmentations aug) {
        super.endCDATA(aug);
        this.lastSource();
    }

    public void endElement(QName element, Augmentations aug) {
        super.endElement(element, aug);
        this.lastSource();
    }
}

