/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator;

import javax.xml.namespace.QName;
import org.eclipse.bpel.fnmeta.FunctionLibrary;
import org.eclipse.bpel.fnmeta.FunctionRegistry;
import org.eclipse.bpel.model.adapters.AdapterRegistry;
import org.eclipse.bpel.validator.AdapterManagerHelper;
import org.eclipse.bpel.validator.EmfModelQuery;
import org.eclipse.bpel.validator.helpers.ModelQueryImpl;
import org.eclipse.bpel.validator.model.IConstants;
import org.eclipse.bpel.validator.model.IFunctionMeta;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.UndefinedNode;
import org.eclipse.bpel.validator.model.XNotImplemented;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.util.WSDLParser;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModelQuery
extends ModelQueryImpl {
    @Override
    public boolean hasSupport(int item, String value) {
        switch (item) {
            case 0: {
                return "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0".equals(value) || "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath2.0".equals(value) || "http://www.w3.org/TR/1999/REC-xpath-19991116".equals(value);
            }
            case 1: {
                return "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0".equals(value) || "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath2.0".equals(value) || "http://www.w3.org/TR/1999/REC-xpath-19991116".equals(value);
            }
            case 2: {
                return "http://www.w3.org/2001/XMLSchema".equals(value) || "http://schemas.xmlsoap.org/wsdl/".equals(value);
            }
            case 3: {
                return false;
            }
        }
        throw new XNotImplemented("Not implemented: hasSupport(item=" + item + ")");
    }

    @Override
    public boolean check(int test, INode n1, INode n2) {
        switch (test) {
            case 0: {
                Object v2;
                if (n1 == n2) {
                    return true;
                }
                if (n1 == null || n2 == null) {
                    return false;
                }
                Object v1 = n1.nodeValue();
                if (v1 == (v2 = n2.nodeValue())) {
                    return true;
                }
                if (v1 != null) {
                    return v1.equals(v2);
                }
                return false;
            }
            case 3: {
                return this.emfModelQuery.compatiblePartnerActivityMessages(this.adapt(n1, EObject.class, 0), this.adapt(n2, EObject.class, 0));
            }
            case 2: {
                return this.emfModelQuery.compatibleType(this.adapt(n1, EObject.class, 0), this.adapt(n2, EObject.class, 0));
            }
            case 1: {
                if (n1 == null || !n1.isResolved()) {
                    return false;
                }
                return EmfModelQuery.isSimpleType(this.adapt(n1, EObject.class, 0));
            }
            case 4: {
                if (n1 == null) {
                    return false;
                }
                return n1.isResolved();
            }
        }
        throw new XNotImplemented("Not implemented: check(test=" + test + ")");
    }

    @Override
    public IFunctionMeta lookupFunction(String language, String ns, String name) {
        FunctionRegistry registry = FunctionLibrary.INSTANCE.getRegistryForLanguage(language);
        if (registry == null) {
            return null;
        }
        return (IFunctionMeta)AdapterRegistry.INSTANCE.adapt((Object)registry.lookupFunction(ns, name), IFunctionMeta.class);
    }

    void ensureEMFReference(EObject eObj, Element elm) {
        Object obj = elm.getUserData("emf.model");
        if (obj != null && obj == eObj) {
            return;
        }
        elm.setUserData("emf.model", eObj, null);
        TreeIterator it = eObj.eAllContents();
        while (it.hasNext()) {
            Object next = it.next();
            Element domElement = null;
            if (next instanceof WSDLElement) {
                domElement = ((WSDLElement)next).getElement();
            } else if (next instanceof XSDConcreteComponent) {
                domElement = ((XSDConcreteComponent)next).getElement();
            }
            if (domElement == null) continue;
            domElement.setUserData("emf.model", next, null);
        }
    }

    @Override
    public INode lookup(INode context, int what, QName qname) {
        if (qname == null) {
            return null;
        }
        String name = qname.getLocalPart();
        EObject eObj = null;
        INode result = null;
        switch (what) {
            case 1: {
                if (context.isResolved()) {
                    result = this.lookupVariable(context, name);
                }
                if (result != null) break;
                result = new UndefinedNode(IConstants.ND_VARIABLE, IConstants.AT_NAME, name);
                break;
            }
            case 3: {
                if (context.isResolved()) {
                    result = this.lookupLink(context, name);
                }
                if (result != null) break;
                result = new UndefinedNode(IConstants.ND_LINK, IConstants.AT_NAME, name);
                break;
            }
            case 5: {
                if (context.isResolved()) {
                    eObj = EmfModelQuery.lookupImport(this.adapt(context, EObject.class, 0), name);
                }
                if (eObj != null) break;
                result = new UndefinedNode(IConstants.ND_IMPORT, new Object[0]);
                break;
            }
            case 2: {
                if (context.isResolved()) {
                    result = this.lookupPartnerLink(context, name);
                }
                if (result != null) break;
                result = new UndefinedNode(IConstants.ND_PARTNER_LINK, IConstants.AT_NAME, name);
                break;
            }
            case 4: {
                if (context.isResolved()) {
                    result = this.lookupCorrelationSet(context, name);
                }
                if (result != null) break;
                result = new UndefinedNode(IConstants.ND_CORRELATION_SET, IConstants.AT_NAME, name);
                break;
            }
            case 10: {
                if (context.isResolved()) {
                    eObj = EmfModelQuery.lookupPartnerLinkType(this.adapt(context, EObject.class, 0), qname);
                }
                if (eObj != null) break;
                result = new UndefinedNode(IConstants.PLNK_ND_PARTNER_LINK_TYPE, IConstants.AT_NAME, qname.getLocalPart());
                break;
            }
            case 11: {
                if (context.isResolved()) {
                    eObj = EmfModelQuery.lookupRole(this.adapt(context, EObject.class, 0), name);
                }
                if (eObj != null) break;
                result = new UndefinedNode(IConstants.PLNK_ND_PARTNER_LINK_TYPE, IConstants.AT_NAME, name);
                break;
            }
            case 6: {
                if (context.isResolved()) {
                    eObj = EmfModelQuery.lookupOperation(this.adapt(context, EObject.class, 0), name);
                }
                if (eObj != null) break;
                result = new UndefinedNode(IConstants.WSDL_ND_OPERATION, IConstants.AT_NAME, name);
                break;
            }
            case 12: {
                if (context.isResolved()) {
                    eObj = EmfModelQuery.lookupPortType(this.adapt(context, EObject.class, 0), qname);
                }
                if (eObj != null) break;
                result = new UndefinedNode(IConstants.WSDL_ND_PORT_TYPE, IConstants.AT_NAME, qname.getLocalPart());
                break;
            }
            case 7: {
                if (context.isResolved()) {
                    eObj = EmfModelQuery.lookupMessage(this.adapt(context, EObject.class, 0), qname);
                }
                if (eObj != null) break;
                result = new UndefinedNode(IConstants.WSDL_ND_MESSAGE, IConstants.AT_NAME, qname.getLocalPart());
                break;
            }
            case 13: {
                return this.adapt(EmfModelQuery.lookupMessagePart(this.adapt(context, EObject.class, 0), name), INode.class, 0);
            }
            case 8: {
                if (context.isResolved()) {
                    eObj = EmfModelQuery.lookupXSDElement(this.adapt(context, EObject.class, 0), qname);
                }
                if (eObj != null) break;
                result = new UndefinedNode(IConstants.AT_ELEMENT, IConstants.AT_NAME, qname.getLocalPart());
                break;
            }
            case 9: {
                if (context.isResolved()) {
                    eObj = EmfModelQuery.lookupXSDType(this.adapt(context, EObject.class, 0), qname);
                }
                if (eObj != null) break;
                result = new UndefinedNode(IConstants.AT_TYPE, IConstants.AT_NAME, qname.getLocalPart());
                break;
            }
            case 14: {
                if (context.isResolved()) {
                    eObj = EmfModelQuery.lookupProperty(this.adapt(context, EObject.class, 0), qname);
                }
                if (eObj != null) break;
                result = new UndefinedNode(IConstants.VPROP_ND_PROPERTY, IConstants.AT_NAME, qname.getLocalPart());
                break;
            }
            case 15: {
                if (context.isResolved()) {
                    eObj = EmfModelQuery.lookupNameStep(this.adapt(context, EObject.class, 0), qname, 0);
                }
                if (eObj != null) break;
                result = new UndefinedNode(IConstants.AT_ELEMENT, IConstants.AT_NAME, qname.getLocalPart());
                break;
            }
            case 17: {
                if (context.isResolved()) {
                    eObj = EmfModelQuery.lookupNameStep(this.adapt(context, EObject.class, 0), qname, 1);
                }
                if (eObj != null) break;
                result = new UndefinedNode(IConstants.AT_ELEMENT, IConstants.AT_NAME, qname.getLocalPart());
                break;
            }
            case 16: {
                if (context.isResolved()) {
                    eObj = EmfModelQuery.lookupTypeOfPart(this.adapt(context, EObject.class, 0), qname);
                }
                if (eObj != null) break;
                result = new UndefinedNode(IConstants.AT_ELEMENT, IConstants.AT_NAME, "Unknown");
                break;
            }
            default: {
                throw new XNotImplemented("Not implemented: lookupNode(item=" + what + ")");
            }
        }
        if (eObj == null) {
            return result;
        }
        return this.adapt(eObj, INode.class, 0);
    }

    @Override
    public String lookup(INode context, int what, String key, String def) {
        switch (what) {
            case 3: {
                return context.nodeName().getLocalPart();
            }
            case 1: {
                return super.lookup(context, what, key, def);
            }
            case 0: {
                return super.lookup(context, what, key, def);
            }
            case 2: {
                return super.lookup(context, what, key, def);
            }
            case 5: {
                EObject eObj = this.adapt(context, EObject.class, 0);
                if (eObj == null || eObj.eResource() == null) break;
                return eObj.eResource().getURIFragment(eObj);
            }
            case 4: {
                EObject eObj = this.adapt(context, EObject.class, 0);
                if (eObj == null || eObj.eResource() == null) break;
                URI uri = eObj.eResource().getURI();
                if (uri.isFile()) {
                    return uri.toFileString();
                }
                return uri.toString();
            }
            case 6: {
                return super.lookup(context, what, key, def);
            }
            default: {
                throw new XNotImplemented("Not implemented: lookupText(item=" + what + ")");
            }
        }
        return def;
    }

    @Override
    public int lookup(INode context, int what, int def) {
        Element elm = this.adapt(context, Element.class, 0);
        if (elm == null) {
            return def;
        }
        String key = null;
        switch (what) {
            case 0: {
                key = "location.line";
                break;
            }
            case 1: {
                key = "location.column";
                break;
            }
            case 2: {
                key = "location.charStart";
                break;
            }
            case 3: {
                key = "location.charEnd";
                break;
            }
            case 4: {
                key = "location2.line";
                break;
            }
            case 5: {
                key = "location2.column";
                break;
            }
            case 6: {
                key = "location2.charStart";
                break;
            }
            case 7: {
                key = "location2.charEnd";
                break;
            }
            default: {
                throw new XNotImplemented("Not implemented: lookupNumber(item=" + what + ")");
            }
        }
        try {
            return ((Number)elm.getUserData(key)).intValue();
        }
        catch (Throwable t) {
            block22: {
                block23: {
                    EObject eObj;
                    block21: {
                        eObj = (EObject)elm.getUserData("emf.model");
                        if (!(eObj instanceof XSDConcreteComponent)) break block21;
                        switch (what) {
                            case 0: {
                                def = XSDParser.getStartLine((Node)((XSDConcreteComponent)eObj).getElement());
                                break block22;
                            }
                            case 1: {
                                def = XSDParser.getStartColumn((Node)((XSDConcreteComponent)eObj).getElement());
                                break block22;
                            }
                            default: {
                                return def;
                            }
                        }
                    }
                    if (!(eObj instanceof WSDLElement)) break block23;
                    switch (what) {
                        case 0: {
                            def = WSDLParser.getStartLine((Node)((WSDLElement)eObj).getElement());
                            break block22;
                        }
                        case 1: {
                            def = WSDLParser.getStartColumn((Node)((WSDLElement)eObj).getElement());
                            break block22;
                        }
                        default: {
                            return def;
                        }
                    }
                }
                return def;
            }
            elm.setUserData(key, def, null);
            return def;
        }
    }

    @Override
    public <T> T adapt(Object target, Class<T> type, int hint) {
        INode aTarget;
        if (type.isInstance(target) || target == null) {
            return type.cast(target);
        }
        T result = super.adapt(target, type, hint);
        if (result != null) {
            return result;
        }
        if (target instanceof INode) {
            aTarget = (INode)target;
            if (type == Element.class) {
                return type.cast(this.adaptINode2Element(aTarget));
            }
            if (type == EObject.class) {
                return type.cast(this.adaptINode2EObject(aTarget));
            }
        }
        if (target instanceof EObject) {
            aTarget = (EObject)target;
            if (type == INode.class) {
                return type.cast(this.adaptEObject2INode((EObject)aTarget));
            }
        }
        IAdapterManager manager = AdapterManagerHelper.getAdapterManager();
        return type.cast(manager.getAdapter(target, type));
    }

    Element adaptINode2Element(INode context) {
        Object value = context.nodeValue();
        if (value instanceof Element) {
            return (Element)value;
        }
        if (value instanceof WSDLElement) {
            return ((WSDLElement)value).getElement();
        }
        if (value instanceof XSDConcreteComponent) {
            return ((XSDConcreteComponent)value).getElement();
        }
        return null;
    }

    INode adaptEObject2INode(EObject target) {
        if (target == null) {
            return null;
        }
        Element domElement = null;
        if (target instanceof WSDLElement) {
            domElement = ((WSDLElement)target).getElement();
        } else if (target instanceof XSDConcreteComponent) {
            domElement = ((XSDConcreteComponent)target).getElement();
        }
        if (domElement != null) {
            this.ensureEMFReference(target, domElement);
            return this.adapt(domElement, INode.class, 0);
        }
        return null;
    }

    EObject adaptINode2EObject(INode context) {
        Object value = context.nodeValue();
        if (value instanceof Element) {
            Element elm = (Element)value;
            return (EObject)elm.getUserData("emf.model");
        }
        if (value instanceof EObject) {
            return (EObject)value;
        }
        if (!context.isResolved()) {
            return null;
        }
        throw new RuntimeException("getEObject() - cannot find EMF Object");
    }
}

