/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.wizards;

import java.util.List;
import org.eclipse.bpel.ui.details.providers.ModelTreeLabelProvider;
import org.eclipse.bpel.ui.details.providers.PortTypeTreeContentProvider;
import org.eclipse.bpel.ui.details.tree.PortTypeTreeNode;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.wizards.Messages;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.PortType;

public class CreatePartnerLinkTypeWizardRolePage
extends WizardPage {
    static final int SIZING_TEXT_FIELD_WIDTH = 250;
    Text roleName;
    Tree portTypeTree;
    TreeViewer portTypeViewer;
    PortType mandatoryPortType;
    PortType optionalPortType;
    Definition mandatoryWsdlDefinition;
    List<Definition> optionalWsdlDefinitions;
    private CreatePartnerLinkTypeWizardRolePage fOtherRolePage;
    boolean fOptional = false;

    protected CreatePartnerLinkTypeWizardRolePage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createRoleName(composite);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    Composite createRoleName(Composite parent) {
        Composite fields = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        fields.setLayout((Layout)layout);
        fields.setLayoutData((Object)new GridData(1808));
        Label label = new Label(fields, 0);
        label.setText(Messages.CreatePartnerLinkTypeWizardRolePage_0);
        label.setFont(parent.getFont());
        this.roleName = new Text(fields, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.roleName.setLayoutData((Object)data);
        this.roleName.setFont(parent.getFont());
        this.roleName.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                CreatePartnerLinkTypeWizardRolePage.this.setPageComplete(CreatePartnerLinkTypeWizardRolePage.this.validatePage());
            }
        });
        label = new Label(fields, 0);
        label.setText(Messages.CreatePartnerLinkTypeWizardRolePage_1);
        label.setFont(parent.getFont());
        this.portTypeTree = new Tree(fields, 2048);
        this.portTypeViewer = new TreeViewer(this.portTypeTree);
        this.portTypeViewer.setContentProvider((IContentProvider)new PortTypeTreeContentProvider(true));
        this.portTypeViewer.setLabelProvider((IBaseLabelProvider)new ModelTreeLabelProvider());
        if (!this.fOptional) {
            this.portTypeViewer.setInput((Object)this.mandatoryWsdlDefinition);
        } else {
            this.portTypeViewer.setInput(this.optionalWsdlDefinitions);
        }
        data = new GridData(1808);
        this.portTypeTree.setLayoutData((Object)data);
        this.portTypeTree.setFont(parent.getFont());
        this.portTypeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)event.getSelection();
                Object obj = ssel.getFirstElement();
                if (obj != null && obj instanceof PortTypeTreeNode) {
                    PortTypeTreeNode pttn = (PortTypeTreeNode)obj;
                    if (!CreatePartnerLinkTypeWizardRolePage.this.fOptional) {
                        CreatePartnerLinkTypeWizardRolePage.this.setMandatoryPortType((PortType)pttn.getModelObject());
                    } else {
                        CreatePartnerLinkTypeWizardRolePage.this.setOptionalPortType((PortType)pttn.getModelObject());
                    }
                    CreatePartnerLinkTypeWizardRolePage.this.setPageComplete(CreatePartnerLinkTypeWizardRolePage.this.validatePage());
                } else {
                    CreatePartnerLinkTypeWizardRolePage.this.setMandatoryPortType(null);
                    CreatePartnerLinkTypeWizardRolePage.this.setPageComplete(CreatePartnerLinkTypeWizardRolePage.this.validatePage());
                }
            }
        });
        return fields;
    }

    boolean validatePage() {
        IInputValidator validator;
        String msg;
        String roleNCName = this.roleName.getText();
        if (this.fOptional) {
            if (this.optionalPortType == null && roleNCName.length() == 0) {
                this.setMessage(Messages.CreatePartnerLinkTypeWizardRolePage_2, 1);
                return true;
            }
        } else if (this.mandatoryPortType == null) {
            this.setMessage(Messages.CreatePartnerLinkTypeWizardRolePage_3, 3);
            return false;
        }
        if ((msg = (validator = BPELUtil.getNCNameValidator()).isValid(roleNCName)) != null) {
            this.setMessage(msg, 3);
            return false;
        }
        if (this.fOtherRolePage != null && roleNCName.equals(this.fOtherRolePage.getRoleName())) {
            this.setMessage(Messages.CreatePartnerLinkTypeWizardRolePage_4, 3);
            return false;
        }
        this.setMessage(null, 0);
        return true;
    }

    public void setMandatoryDefinition(Definition defn) {
        this.mandatoryWsdlDefinition = defn;
    }

    public void setMandatoryPortType(PortType pt) {
        this.mandatoryPortType = pt;
    }

    public PortType getMandatoryPortType() {
        return this.mandatoryPortType;
    }

    public void setOptionalDefinitions(List<Definition> defs) {
        this.optionalWsdlDefinitions = defs;
    }

    public void setOptionalPortType(PortType pt) {
        this.optionalPortType = pt;
    }

    public PortType getOptionalPortType() {
        return this.optionalPortType;
    }

    public String getRoleName() {
        return this.roleName.getText();
    }

    public void setOtherRolePage(CreatePartnerLinkTypeWizardRolePage otherRole) {
        this.fOtherRolePage = otherRole;
    }

    public void setOptional(boolean b) {
        this.fOptional = b;
    }

    public boolean isSpecified() {
        if (this.fOptional && this.optionalPortType == null) {
            return false;
        }
        return this.isPageComplete();
    }
}

