/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.figures;

import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class BPELPolylineConnection
extends PolylineConnection {
    private static final int LEFT_RIGHT = 0;
    private static final int RIGHT_LEFT = 1;
    private static final int TOP_BOTTOM = 2;
    private static final int BOTTOM_TOP = 3;
    Color color1;
    Color color2;
    Color color3;
    Image topLeft;
    Image topRight;
    Image bottomLeft;
    Image bottomRight;
    Image arrowDown;
    Image arrowRight;

    public BPELPolylineConnection(Image topLeft, Image topRight, Image bottomLeft, Image bottomRight, Image arrowDown, Image arrowRight) {
        BPELUIPlugin plugin = BPELUIPlugin.INSTANCE;
        ColorRegistry colorRegistry = plugin.getColorRegistry();
        this.color1 = colorRegistry.get("linkOne");
        this.color2 = colorRegistry.get("linkTwo");
        this.color3 = colorRegistry.get("linkThree");
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomLeft = bottomLeft;
        this.bottomRight = bottomRight;
        this.arrowDown = arrowDown;
        this.arrowRight = arrowRight;
        this.setLineWidth(12);
    }

    protected void outlineShape(Graphics g) {
        PointList list = this.getPoints();
        int size = list.size();
        int lastDirection = 0;
        int i = 0;
        while (i < size - 1) {
            Point p1 = list.getPoint(i);
            Point p2 = list.getPoint(i + 1);
            int direction = p1.x == p2.x ? (p1.y > p2.y ? 3 : 2) : (p1.x > p2.x ? 1 : 0);
            if (i == size - 2) {
                Image arrowImage = this.arrowDown;
                if (direction == 1 || direction == 0) {
                    arrowImage = this.arrowRight;
                }
                g.drawImage(arrowImage, p2.x - 6, p2.y - 6);
            }
            if (i == size - 2) {
                if (direction == 1 || direction == 0) {
                    p2.x -= 4;
                } else {
                    p2.y -= 4;
                }
            }
            g.setLineWidth(1);
            g.setForegroundColor(this.color2);
            g.drawLine(p1, p2);
            if (direction == 3 || direction == 2) {
                g.setForegroundColor(this.color1);
                g.drawLine(p1.x - 1, p1.y, p2.x - 1, p2.y);
                g.setForegroundColor(this.color3);
                g.drawLine(p1.x + 1, p1.y, p2.x + 1, p2.y);
            } else {
                g.setForegroundColor(this.color1);
                g.drawLine(p1.x, p1.y - 1, p2.x, p2.y - 1);
                g.setForegroundColor(this.color3);
                g.drawLine(p1.x, p1.y + 1, p2.x, p2.y + 1);
            }
            if (i != 0) {
                Image image;
                switch (lastDirection) {
                    case 2: {
                        if (direction == 0) {
                            image = this.bottomLeft;
                            break;
                        }
                        image = this.bottomRight;
                        break;
                    }
                    case 3: {
                        if (direction == 0) {
                            image = this.topLeft;
                            break;
                        }
                        image = this.topRight;
                        break;
                    }
                    case 0: {
                        if (direction == 2) {
                            image = this.topRight;
                            break;
                        }
                        image = this.bottomRight;
                        break;
                    }
                    default: {
                        image = direction == 2 ? this.topLeft : this.bottomLeft;
                    }
                }
                g.drawImage(image, p1.x - 1, p1.y - 1);
            }
            lastDirection = direction;
            ++i;
        }
    }
}

