/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.editmodel;

import org.eclipse.bpel.common.ui.editmodel.ResourceInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Display;

class ResourceListener
implements IResourceChangeListener {
    ResourceInfo fModelInfo;
    IFile fFile;
    static Runner runner = new Runner(){

        @Override
        public void run(Runnable runnable) {
            Display.getDefault().asyncExec(runnable);
        }
    };

    protected ResourceListener(ResourceInfo modelInfo, IFile fileResource) {
        this.fModelInfo = modelInfo;
        this.fFile = fileResource;
    }

    public void setFile(IFile file) {
        this.fFile = file;
    }

    public void resourceChanged(IResourceChangeEvent e) {
        IResourceDelta delta = e.getDelta();
        if (delta != null) {
            delta = delta.findMember(this.fFile.getFullPath());
        }
        if (delta != null) {
            switch (delta.getKind()) {
                case 4: {
                    if ((delta.getFlags() & 0x100) != 0 && !this.isDirty()) {
                        this.fireModelRefresh();
                    }
                    if ((delta.getFlags() & 0x20000) == 0) break;
                    this.fireMarkerChange(delta.getMarkerDeltas());
                    break;
                }
                case 2: {
                    if ((delta.getFlags() & 0x2000) != 0) {
                        this.fireModelMoved(delta.getMovedToPath());
                        break;
                    }
                    if (this.isDirty()) break;
                    this.fireModelDeleted();
                }
            }
        }
    }

    private void fireMarkerChange(final IMarkerDelta[] delta) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ResourceListener.this.fModelInfo.markersChanged(delta);
            }
        };
        this.run(runnable);
    }

    private void fireModelRefresh() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ResourceListener.this.fModelInfo.refresh();
            }
        };
        this.run(runnable);
    }

    private void fireModelMoved(final IPath path) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IFile movedTofile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                if (ResourceListener.this.fFile == null) {
                    return;
                }
                ResourceListener.this.fModelInfo.move(movedTofile);
                ResourceListener.this.fFile = movedTofile;
            }
        };
        this.run(runnable);
    }

    private void fireModelDeleted() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ResourceListener.this.fModelInfo.deleted();
                ResourceListener.this.fModelInfo.dispose();
            }
        };
        this.run(runnable);
    }

    protected boolean isDirty() {
        if (this.fModelInfo.getResource() == null) {
            return false;
        }
        return this.fModelInfo.getResource().isModified();
    }

    public void run(Runnable runnable) {
        if (runner == null) {
            runnable.run();
        } else {
            runner.run(runnable);
        }
    }

    static interface Runner {
        public void run(Runnable var1);
    }
}

